/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketAddress;
import java.time.Duration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AddressSpecifics;
import org.newsclub.net.unix.SocketTestBase;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@SuppressFBWarnings(value={"THROWS_METHOD_THROWS_CLAUSE_THROWABLE", "THROWS_METHOD_THROWS_CLAUSE_BASIC_EXCEPTION"})
public abstract class ReadWriteTest<A extends SocketAddress>
extends SocketTestBase<A> {
    private static final byte[] DATA = new byte[]{-127, -2, -1, 0, 1, 2, 127, 1, 2, 4, 8, 16, 31};

    protected ReadWriteTest(AddressSpecifics<A> asp) {
        super(asp);
    }

    @Test
    public void testReceiveWithByteArraySendWithByteArray() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(2L), () -> {
            try (ByteArrayWritingServerThread serverThread = new ByteArrayWritingServerThread();){
                this.receiveDataWithByteArray(serverThread.getServerAddress());
            }
        });
    }

    @Test
    public void testReceiveDataByteForByteSendWithByteArray() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(2L), () -> {
            try (ByteArrayWritingServerThread serverThread = new ByteArrayWritingServerThread();){
                this.receiveDataByteForByte(serverThread.getServerAddress());
            }
        });
    }

    @Test
    public void testReceiveWithByteArraySendByteForByte() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(2L), () -> {
            try (ByteForByteWritingServerThread serverThread = new ByteForByteWritingServerThread();){
                this.receiveDataWithByteArray(serverThread.getServerAddress());
            }
        });
    }

    @Test
    public void testReceiveDataByteForByteSendByteForByte() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(2L), () -> {
            try (ByteForByteWritingServerThread serverThread = new ByteForByteWritingServerThread();){
                this.receiveDataByteForByte(serverThread.getServerAddress());
            }
        });
    }

    private void receiveDataWithByteArray(SocketAddress serverAddress) throws IOException {
        try (Socket sock = this.connectTo(serverAddress);
             InputStream in = sock.getInputStream();
             OutputStream out = sock.getOutputStream();){
            int read;
            byte[] buf = new byte[4096];
            int numReceived = 0;
            while ((read = in.read(buf, numReceived, buf.length - numReceived)) >= 0 && (numReceived += read) < DATA.length) {
            }
            Assertions.assertEquals((int)DATA.length, (int)numReceived);
            byte[] received = new byte[numReceived];
            System.arraycopy(buf, 0, received, 0, numReceived);
            Assertions.assertArrayEquals((byte[])DATA, (byte[])received);
            out.write(numReceived);
        }
    }

    private void receiveDataByteForByte(SocketAddress serverAddress) throws IOException {
        try (Socket sock = this.connectTo(serverAddress);
             InputStream in = sock.getInputStream();
             OutputStream out = sock.getOutputStream();){
            int ret;
            byte[] buf = new byte[4096];
            int numReceived = 0;
            while ((ret = in.read()) != -1) {
                Assertions.assertTrue((ret >= 0 ? 1 : 0) != 0);
                buf[numReceived++] = (byte)ret;
                if (numReceived != DATA.length) continue;
            }
            Assertions.assertEquals((int)numReceived, (int)DATA.length);
            byte[] received = new byte[numReceived];
            System.arraycopy(buf, 0, received, 0, numReceived);
            Assertions.assertArrayEquals((byte[])DATA, (byte[])received);
            out.write(numReceived);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private final class ByteForByteWritingServerThread
    extends SocketTestBase.ServerThread {
        public ByteForByteWritingServerThread() throws IOException, InterruptedException {
            super(ReadWriteTest.this);
        }

        @Override
        protected void handleConnection(Socket sock) throws IOException {
            try (OutputStream out = sock.getOutputStream();
                 InputStream in = sock.getInputStream();){
                for (byte b : DATA) {
                    out.write(b);
                }
                int dataLength = in.read();
                Assertions.assertEquals((int)DATA.length, (int)dataLength);
                Assertions.assertEquals((int)-1, (int)in.read());
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private final class ByteArrayWritingServerThread
    extends SocketTestBase.ServerThread {
        public ByteArrayWritingServerThread() throws IOException, InterruptedException {
            super(ReadWriteTest.this);
        }

        @Override
        protected void handleConnection(Socket sock) throws IOException {
            try (OutputStream out = sock.getOutputStream();
                 InputStream in = sock.getInputStream();){
                out.write(DATA);
                byte[] buf = new byte[4096];
                int numReceived = in.read(buf);
                Assertions.assertEquals((int)1, (int)numReceived);
                Assertions.assertEquals((int)buf[0], (int)DATA.length);
            }
        }
    }
}

