/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.rmi;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import com.kohlschutter.testutil.TestStackTraceUtil;
import com.kohlschutter.util.SystemPropertyUtil;
import java.io.File;
import java.io.IOException;
import java.rmi.AlreadyBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import org.newsclub.net.unix.rmi.AFUNIXNaming;
import org.newsclub.net.unix.rmi.HelloImpl;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class TestRegistryServer {
    public static void main(String[] args) throws AlreadyBoundException, IOException, InterruptedException {
        File socketDir;
        AFUNIXNaming naming;
        String socketDirStr = System.getProperty("rmitest.junixsocket.socket-dir", "");
        if (socketDirStr.isEmpty()) {
            naming = AFUNIXNaming.getInstance();
        } else {
            socketDir = new File(socketDirStr);
            if (!socketDir.mkdirs() && !socketDir.exists()) {
                throw new IOException("Could not create socketDir: " + String.valueOf(socketDir));
            }
            naming = AFUNIXNaming.getInstance((File)socketDir);
        }
        naming.setRemoteShutdownAllowed(SystemPropertyUtil.getBooleanSystemProperty((String)"rmitest.junixsocket.remote-shutdown.allowed", (boolean)true));
        socketDir = naming.getRegistrySocketDir();
        System.out.println(socketDir);
        if (SystemPropertyUtil.getBooleanSystemProperty((String)"rmitest.junixsocket.create-registry", (boolean)true)) {
            naming.createRegistry();
        }
        if (SystemPropertyUtil.getBooleanSystemProperty((String)"rmitest.junixsocket.export-hello", (boolean)true)) {
            int delay = SystemPropertyUtil.getIntSystemProperty((String)"rmitest.junixsocket.export-hello.delay", (int)0);
            if (delay > 0) {
                System.out.println("Delaying Hello export by " + delay + " ms");
                try {
                    Thread.sleep(delay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            naming.exportAndBind("hello", (Remote)new HelloImpl());
        }
        System.out.println("Server is ready");
        final int shutdownAfter = SystemPropertyUtil.getIntSystemProperty((String)"rmitest.junixsocket.shutdown-after.secs", (int)-1);
        if (shutdownAfter >= 0) {
            Thread t = new Thread(){

                @Override
                @SuppressFBWarnings(value={"DM_EXIT"})
                public void run() {
                    try {
                        Thread.sleep((long)shutdownAfter * 1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    try {
                        naming.shutdownRegistry();
                    }
                    catch (RemoteException e) {
                        TestStackTraceUtil.printStackTrace((Throwable)e);
                    }
                    System.exit(0);
                }
            };
            t.setDaemon(true);
            t.start();
        }
    }
}

