/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.time.Duration;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.newsclub.net.unix.AddressSpecifics;
import org.newsclub.net.unix.SocketTestBase;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@SuppressFBWarnings(value={"THROWS_METHOD_THROWS_CLAUSE_THROWABLE", "THROWS_METHOD_THROWS_CLAUSE_BASIC_EXCEPTION"})
public abstract class ServerSocketCloseTest<A extends SocketAddress>
extends SocketTestBase<A> {
    protected ServerSocketCloseTest(AddressSpecifics<A> asp) {
        super(asp);
    }

    @Test
    @Timeout(value=60L, unit=TimeUnit.SECONDS)
    public void testUnblockAcceptsWithSoTimeout() throws Exception {
        this.testUnblockAccepts(60000);
    }

    @Test
    public void testUnblockAcceptsWithoutSoTimeout() throws Exception {
        this.testUnblockAccepts(0);
    }

    private void testUnblockAccepts(int timeout) throws Exception {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(30L), () -> {
            try (final ServerSocket serverSocket = this.newServerSocketBindOn(this.getServerBindAddress());){
                serverSocket.setSoTimeout(timeout);
                int numThreads = 4;
                final CountDownLatch cdl = new CountDownLatch(4);
                ThreadPoolExecutor threadPool = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
                for (int i = 0; i < 4; ++i) {
                    threadPool.submit(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                cdl.countDown();
                                try (Socket accept = serverSocket.accept();){
                                    Assertions.assertNotNull((Object)accept);
                                }
                            }
                            catch (SocketException e) {
                                if (!serverSocket.isClosed()) {
                                    Assertions.fail((Throwable)e);
                                }
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                                Assertions.fail((Throwable)e);
                            }
                        }
                    });
                }
                cdl.await();
                Thread.sleep(100L);
                serverSocket.close();
                threadPool.shutdown();
                threadPool.awaitTermination(5L, TimeUnit.SECONDS);
                int active = threadPool.getActiveCount();
                if (active == 4) {
                    this.checkFailedTestActuallySupported();
                }
                Assertions.assertEquals((int)0, (int)active, (String)"There should be no pending accepts");
            }
        });
    }

    protected void checkFailedTestActuallySupported() {
    }
}

