/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import com.kohlschutter.testutil.AssertUtil;
import com.kohlschutter.testutil.TestAbortedWithImportantMessageException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AddressSpecifics;
import org.newsclub.net.unix.CloseablePair;
import org.newsclub.net.unix.SocketTestBase;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@SuppressFBWarnings(value={"THROWS_METHOD_THROWS_CLAUSE_THROWABLE", "THROWS_METHOD_THROWS_CLAUSE_BASIC_EXCEPTION"})
public abstract class SoTimeoutTest<A extends SocketAddress>
extends SocketTestBase<A> {
    protected SoTimeoutTest(AddressSpecifics<A> asp) {
        super(asp);
    }

    @Test
    public void issue14Fail() throws Exception {
        final Semaphore sema = new Semaphore(0);
        try (SocketTestBase.ServerThread serverThread = new SocketTestBase.ServerThread(){

            @Override
            protected void handleConnection(Socket socket) throws IOException {
                try {
                    socket.close();
                }
                finally {
                    sema.release();
                }
            }
        };
             Socket sock = this.connectTo(serverThread.getServerAddress());){
            sema.acquire();
            try {
                sock.setSoTimeout((int)TimeUnit.SECONDS.toMillis(12L));
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
    }

    @Test
    public void issue14Pass() throws Exception {
        final Semaphore sema = new Semaphore(0);
        try (SocketTestBase.ServerThread serverThread = new SocketTestBase.ServerThread(){

            @Override
            protected void handleConnection(Socket sock) throws IOException {
                try (InputStream inputStream = sock.getInputStream();){
                    inputStream.read();
                    sema.acquire();
                }
                catch (IOException | InterruptedException exception) {
                    // empty catch block
                }
            }
        };
             Socket sock = this.connectTo(serverThread.getServerAddress());){
            Assertions.assertTrue((boolean)sock.isConnected());
            Assertions.assertFalse((boolean)sock.isClosed());
            try {
                sock.setSoTimeout((int)TimeUnit.SECONDS.toMillis(12L));
            }
            catch (IOException e) {
                e.printStackTrace();
                throw e;
            }
            finally {
                sema.release();
            }
        }
    }

    @Test
    public void testSocketTimeoutExceptionRead() throws Exception {
        try (CloseablePair<Socket> pair = this.newInterconnectedSockets();){
            Socket socket = (Socket)pair.getSecond();
            socket.setSoTimeout(500);
            byte[] buf = new byte[socket.getReceiveBufferSize()];
            InputStream in = socket.getInputStream();
            Assertions.assertThrows(SocketTimeoutException.class, () -> AssertUtil.ignoreValue((Object)in.read(buf)));
        }
    }

    @Test
    public void testSocketTimeoutExceptionWrite() throws Exception {
        try (CloseablePair<Socket> pair = this.newInterconnectedSockets();){
            Socket socket = (Socket)pair.getSecond();
            socket.setSoTimeout(500);
            if (socket.getSoTimeout() == 0) {
                boolean isZOS = "z/OS".equals(System.getProperty("os.name", ""));
                String afs = this.addressFamilyString();
                if (isZOS && "AF_UNIX".equals(afs)) {
                    throw new TestAbortedWithImportantMessageException(TestAbortedWithImportantMessageException.MessageType.TEST_ABORTED_WITH_ISSUES, "Could not set socket timeout via Socket.setSoTimeout (" + this.addressFamilyString() + "); this is a known limitation of z/OS");
                }
                throw new TestAbortedWithImportantMessageException(TestAbortedWithImportantMessageException.MessageType.TEST_ABORTED_WITH_ISSUES, "Could not set socket timeout via Socket.setSoTimeout (" + this.addressFamilyString() + ")");
            }
            byte[] buf = new byte[socket.getSendBufferSize()];
            OutputStream out = socket.getOutputStream();
            try {
                out.write(buf);
                out.write(buf);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                // empty catch block
            }
        }
    }
}

