/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import com.kohlschutter.testutil.AssertUtil;
import java.io.IOException;
import java.net.SocketException;
import java.net.URI;
import java.util.Arrays;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AFAddressFamily;
import org.newsclub.net.unix.AFSocket;
import org.newsclub.net.unix.AFSocketCapability;
import org.newsclub.net.unix.AFSocketProtocol;
import org.newsclub.net.unix.AFSocketType;
import org.newsclub.net.unix.AFVSOCKSocketAddress;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class AFVSOCKSocketAddressTest {
    @Test
    public void testSchemesAvailable() throws Exception {
        AssertUtil.assertSetContains((Set)AFAddressFamily.uriSchemes(), Arrays.asList("vsock", "http+vsock", "https+vsock"));
    }

    @Test
    public void testParseFail() throws Exception {
        Assertions.assertThrows(SocketException.class, () -> AFVSOCKSocketAddress.of((URI)URI.create("vsock://invalid")));
        Assertions.assertThrows(SocketException.class, () -> AFVSOCKSocketAddress.of((URI)URI.create("vsock://socket.23/")));
    }

    private AFVSOCKSocketAddress validateAddress(String uri) throws IOException {
        URI u = URI.create(uri);
        AFVSOCKSocketAddress address = AFVSOCKSocketAddress.of((URI)u);
        URI u2 = address.toURI(u.getScheme(), null);
        Assertions.assertEquals((Object)address, (Object)AFVSOCKSocketAddress.of((URI)u2));
        return address;
    }

    @Test
    public void testSocketURI() throws Exception {
        Assertions.assertEquals((Object)AFVSOCKSocketAddress.ofPortAndCID((int)123, (int)456), (Object)this.validateAddress("vsock://123.456"));
        Assertions.assertEquals((Object)AFVSOCKSocketAddress.ofPortAndCID((int)123, (int)0), (Object)this.validateAddress("vsock://123.hypervisor"));
        Assertions.assertEquals((Object)AFVSOCKSocketAddress.ofPortAndCID((int)0, (int)0), (Object)this.validateAddress("vsock://0.hypervisor"));
        Assertions.assertEquals((Object)AFVSOCKSocketAddress.ofPortAndCID((int)0, (int)0), (Object)this.validateAddress("vsock://0.hypervisor"));
        Assertions.assertEquals((Object)AFVSOCKSocketAddress.ofPortAndCID((int)-1, (int)0), (Object)this.validateAddress("vsock://any.hypervisor"));
        Assertions.assertEquals((Object)this.validateAddress("vsock://-1.0"), (Object)this.validateAddress("vsock://any.hypervisor"));
        Assertions.assertEquals((Object)this.validateAddress("vsock://0xffffffff.0"), (Object)this.validateAddress("vsock://any.hypervisor"));
        Assertions.assertEquals((Object)this.validateAddress("vsock://456.any"), (Object)this.validateAddress("vsock://456.-1"));
        Assertions.assertEquals((Object)AFVSOCKSocketAddress.ofAnyPort(), (Object)this.validateAddress("vsock://any"));
        Assertions.assertEquals((Object)AFVSOCKSocketAddress.ofAnyLocalPort(), (Object)this.validateAddress("vsock://-1.local"));
        Assertions.assertEquals((Object)AFVSOCKSocketAddress.ofAnyLocalPort(), (Object)this.validateAddress("vsock://any.local"));
        Assertions.assertEquals((Object)AFVSOCKSocketAddress.ofLocalPort((int)456), (Object)this.validateAddress("vsock://456.local"));
        Assertions.assertEquals((Object)AFVSOCKSocketAddress.ofLocalPort((int)456), (Object)this.validateAddress("vsock://456.local"));
        Assertions.assertEquals((Object)AFVSOCKSocketAddress.ofHostPort((int)456), (Object)this.validateAddress("vsock://456.host"));
        Assertions.assertEquals((Object)AFVSOCKSocketAddress.ofAnyHostPort(), (Object)this.validateAddress("vsock://any.host"));
    }

    @Test
    public void testNamedCIDs() throws Exception {
        Assertions.assertEquals((Object)AFVSOCKSocketAddress.ofPortAndCID((int)-1, (int)0), (Object)AFVSOCKSocketAddress.ofAnyHypervisorPort());
        Assertions.assertEquals((Object)AFVSOCKSocketAddress.ofPortAndCID((int)-1, (int)1), (Object)AFVSOCKSocketAddress.ofAnyLocalPort());
        Assertions.assertEquals((Object)AFVSOCKSocketAddress.ofPortAndCID((int)-1, (int)2), (Object)AFVSOCKSocketAddress.ofAnyHostPort());
        Assertions.assertEquals((Object)AFVSOCKSocketAddress.ofPortAndCID((int)567, (int)0), (Object)AFVSOCKSocketAddress.ofHypervisorPort((int)567));
        Assertions.assertEquals((Object)AFVSOCKSocketAddress.ofPortAndCID((int)101112, (int)1), (Object)AFVSOCKSocketAddress.ofLocalPort((int)101112));
        Assertions.assertEquals((Object)AFVSOCKSocketAddress.ofPortAndCID((int)2345, (int)2), (Object)AFVSOCKSocketAddress.ofHostPort((int)2345));
    }

    @Test
    public void testSocatString() throws Exception {
        String socatString;
        try {
            socatString = AFVSOCKSocketAddress.ofPortAndCID((int)123, (int)4).toSocatAddressString(AFSocketType.SOCK_STREAM, AFSocketProtocol.DEFAULT);
            Assertions.assertNotNull((Object)socatString);
        }
        catch (SocketException e) {
            if (AFSocket.supports((AFSocketCapability)AFSocketCapability.CAPABILITY_VSOCK)) {
                throw e;
            }
            return;
        }
        Assertions.assertTrue((boolean)socatString.contains(":"));
    }
}

