/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.domain;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.newsclub.net.unix.AFSocketCapability;
import org.newsclub.net.unix.AFSocketCapabilityRequirement;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.domain.AFUNIXAddressSpecifics;
import org.opentest4j.TestAbortedException;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@AFSocketCapabilityRequirement(value={AFSocketCapability.CAPABILITY_UNIX_DOMAIN})
@SuppressFBWarnings(value={"NM_SAME_SIMPLE_NAME_AS_SUPERCLASS"})
public final class FinalizeTest
extends org.newsclub.net.unix.FinalizeTest<AFUNIXSocketAddress> {
    public FinalizeTest() {
        super(AFUNIXAddressSpecifics.INSTANCE);
    }

    @Override
    protected String socketType() {
        return "UNIX";
    }

    @SuppressFBWarnings(value={"RV_DONT_JUST_NULL_CHECK_READLINE"})
    private static int lsofUnixSockets(long pid) throws IOException, TestAbortedException, InterruptedException {
        Process p;
        Assertions.assertTrue((pid > 0L ? 1 : 0) != 0);
        try {
            p = Runtime.getRuntime().exec(new String[]{"lsof", "-U", "-a", "-p", String.valueOf(pid)});
        }
        catch (Exception e) {
            Assumptions.assumeTrue((boolean)false, (String)e.getMessage());
            return -1;
        }
        int lines = 0;
        try (BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream(), Charset.defaultCharset()));){
            String l;
            while ((l = in.readLine()) != null) {
                ++lines;
                if (!l.contains("busybox")) continue;
                Assumptions.assumeTrue((boolean)false, (String)"incompatible lsof binary");
            }
        }
        Assumptions.assumeTrue((p.waitFor() == 0 ? 1 : 0) != 0, (String)"lsof should terminate with RC=0");
        return lines;
    }

    @Override
    protected Object preRunCheck(Process process) throws TestAbortedException, IOException, InterruptedException {
        int linesBefore = FinalizeTest.lsofUnixSockets(process.pid());
        Assumptions.assumeTrue((linesBefore > 0 ? 1 : 0) != 0);
        return linesBefore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void postRunCheck(Process process, Object linesBeforeObj) throws TestAbortedException, IOException, InterruptedException {
        Assertions.assertNotNull((Object)linesBeforeObj);
        int linesBefore = (Integer)linesBeforeObj;
        try {
            int linesAfter = 0;
            for (int i = 0; i < 10; ++i) {
                Thread.sleep(100L);
                linesAfter = FinalizeTest.lsofUnixSockets(process.pid());
                if (linesAfter != linesBefore || !process.isAlive()) break;
            }
            Assumptions.assumeTrue((linesAfter > 0 ? 1 : 0) != 0, (String)"lsof may fail to return anything");
            Assertions.assertTrue((linesAfter < linesBefore ? 1 : 0) != 0, (String)"Our unix socket file handle should have been cleared out");
        }
        finally {
            process.destroy();
            process.waitFor();
        }
    }
}

