/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.java;

import java.io.IOException;
import java.net.BindException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import org.newsclub.net.unix.AddressSpecifics;
import org.newsclub.net.unix.CloseablePair;
import org.opentest4j.TestAbortedException;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class JavaAddressSpecifics
implements AddressSpecifics<InetSocketAddress> {
    public static final AddressSpecifics<InetSocketAddress> INSTANCE = new JavaAddressSpecifics();

    private JavaAddressSpecifics() {
    }

    public static SocketAddress wildcardBindAddress() throws IOException {
        InetSocketAddress bindAddr = new InetSocketAddress(InetAddress.getLoopbackAddress(), 0);
        try (ServerSocket sock = new ServerSocket();){
            sock.bind(bindAddr);
        }
        catch (BindException e) {
            throw new TestAbortedException("Cannot bind to " + bindAddr, (Throwable)e);
        }
        return bindAddr;
    }

    @Override
    public SocketAddress initServerSocketBindAddress() throws IOException {
        return JavaAddressSpecifics.wildcardBindAddress();
    }

    @Override
    public Socket newStrictSocket() throws IOException {
        return this.newSocket();
    }

    @Override
    public Socket newSocket() throws IOException {
        return new Socket();
    }

    @Override
    public DatagramSocket newDatagramSocket() throws IOException {
        return new DatagramSocket();
    }

    @Override
    public DatagramChannel newDatagramChannel() throws IOException {
        return this.selectorProvider().openDatagramChannel();
    }

    @Override
    public ServerSocket newServerSocket() throws IOException {
        return new ServerSocket();
    }

    @Override
    public SocketAddress newTempAddress() throws IOException {
        return new InetSocketAddress(InetAddress.getLoopbackAddress(), 0);
    }

    @Override
    public SocketAddress unwrap(InetAddress addr, int port) throws SocketException {
        return new InetSocketAddress(addr, port);
    }

    @Override
    public SelectorProvider selectorProvider() {
        return SelectorProvider.provider();
    }

    @Override
    public CloseablePair<? extends SocketChannel> newSocketPair() throws IOException {
        CloseablePair<Socket> p1 = this.newInterconnectedSockets();
        return new CloseablePair<SocketChannel>(p1.getFirst().getChannel(), p1.getSecond().getChannel(), p1);
    }

    @Override
    public CloseablePair<? extends DatagramChannel> newDatagramSocketPair() throws IOException {
        DatagramSocket ds1 = new DatagramSocket(0);
        DatagramSocket ds2 = new DatagramSocket(0);
        ds1.connect(ds2.getLocalSocketAddress());
        ds2.connect(ds1.getLocalSocketAddress());
        return new CloseablePair<DatagramChannel>(ds1.getChannel(), ds2.getChannel(), () -> {
            ds1.close();
            ds2.close();
        });
    }

    @Override
    public ServerSocket newServerSocketBindOn(SocketAddress addr) throws IOException {
        InetSocketAddress inetAddr = (InetSocketAddress)addr;
        if (!inetAddr.getAddress().isAnyLocalAddress()) {
            throw new IllegalArgumentException("Not a local address: " + inetAddr);
        }
        return new ServerSocket(inetAddr.getPort());
    }

    @Override
    public Socket connectTo(SocketAddress addr) throws IOException {
        InetSocketAddress isa = (InetSocketAddress)addr;
        return new Socket(isa.getAddress(), isa.getPort());
    }

    @Override
    public ServerSocket newServerSocketBindOn(SocketAddress addr, boolean deleteOnClose) throws IOException {
        InetSocketAddress inetAddr = (InetSocketAddress)addr;
        if (!inetAddr.getAddress().isAnyLocalAddress()) {
            throw new IllegalArgumentException("Not a local address: " + inetAddr);
        }
        return new ServerSocket(inetAddr.getPort());
    }
}

