/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AddressSpecifics;
import org.newsclub.net.unix.SocketTestBase;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@SuppressFBWarnings(value={"THROWS_METHOD_THROWS_CLAUSE_THROWABLE", "THROWS_METHOD_THROWS_CLAUSE_BASIC_EXCEPTION"})
public abstract class TcpNoDelayTest<A extends SocketAddress>
extends SocketTestBase<A> {
    protected TcpNoDelayTest(AddressSpecifics<A> asp) {
        super(asp);
    }

    @Test
    public void testStrictImpl() throws Exception {
        try (SocketTestBase.ServerThread serverThread = new SocketTestBase.ServerThread(){

            @Override
            protected void handleConnection(Socket sock) throws IOException {
            }

            @Override
            protected SocketTestBase.ExceptionHandlingDecision handleException(Exception e) {
                if (e instanceof SocketException) {
                    return SocketTestBase.ExceptionHandlingDecision.IGNORE;
                }
                return super.handleException(e);
            }

            @Override
            protected void onServerSocketClose() {
            }
        };
             Socket sock = this.newStrictSocket();){
            sock.connect(serverThread.getServerAddress());
            boolean gotException = false;
            try {
                sock.setTcpNoDelay(true);
            }
            catch (SocketException e) {
                gotException = true;
            }
            if (!gotException) {
                sock.getTcpNoDelay();
            }
        }
    }

    @Test
    public void testDefaultImpl() throws Exception {
        try (SocketTestBase.ServerThread serverThread = new SocketTestBase.ServerThread(){

            @Override
            protected void handleConnection(Socket sock) throws IOException {
            }

            @Override
            protected SocketTestBase.ExceptionHandlingDecision handleException(Exception e) {
                if (e instanceof SocketException) {
                    return SocketTestBase.ExceptionHandlingDecision.IGNORE;
                }
                return super.handleException(e);
            }

            @Override
            protected void onServerSocketClose() {
            }
        };
             Socket sock = this.connectTo(serverThread.getServerAddress());){
            sock.setTcpNoDelay(true);
        }
    }
}

