/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AFDatagramSocket;
import org.newsclub.net.unix.AFDatagramUtil;
import org.newsclub.net.unix.AFSocketAddress;
import org.newsclub.net.unix.AFSocketCapability;
import org.newsclub.net.unix.AFSocketCapabilityRequirement;
import org.newsclub.net.unix.AddressSpecifics;
import org.newsclub.net.unix.SocketTestBase;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@AFSocketCapabilityRequirement(value={AFSocketCapability.CAPABILITY_UNIX_DATAGRAMS})
@SuppressFBWarnings(value={"THROWS_METHOD_THROWS_CLAUSE_THROWABLE", "THROWS_METHOD_THROWS_CLAUSE_BASIC_EXCEPTION"})
public abstract class DatagramSocketTest<A extends SocketAddress>
extends SocketTestBase<A> {
    protected DatagramSocketTest(AddressSpecifics<A> asp) {
        super(asp);
    }

    private void assertUnconnectedDatagramSocket(DatagramSocket ds) {
        Assertions.assertFalse((boolean)ds.isClosed());
        Assertions.assertFalse((boolean)ds.isConnected());
        Assertions.assertEquals((int)0, (int)ds.getLocalPort());
        this.assertUnconnectedUnbound(ds);
    }

    protected void assertUnconnectedUnbound(DatagramSocket ds) {
        Assertions.assertFalse((boolean)ds.isBound());
        Assertions.assertTrue((boolean)ds.getLocalAddress().isAnyLocalAddress());
        Assertions.assertNull((Object)ds.getLocalSocketAddress());
    }

    private static void assertClosedDatagramSocket(DatagramSocket ds) {
        Assertions.assertTrue((boolean)ds.isClosed());
        Assertions.assertNull((Object)ds.getLocalAddress());
        Assertions.assertNull((Object)ds.getLocalSocketAddress());
        Assertions.assertEquals((int)-1, (int)ds.getLocalPort());
    }

    private void assertBoundDatagramSocket(DatagramSocket ds, SocketAddress boundAddr) throws SocketException {
        Assertions.assertTrue((boolean)ds.isBound());
        Assertions.assertFalse((boolean)ds.isClosed());
        Assertions.assertEquals((int)0, (int)ds.getLocalPort());
        Assertions.assertFalse((boolean)ds.getLocalAddress().isAnyLocalAddress());
        this.assertBoundAddrIdenticalToLocalAddress(ds, boundAddr);
    }

    protected void assertBoundAddrIdenticalToLocalAddress(DatagramSocket ds, SocketAddress boundAddr) throws SocketException {
        Assertions.assertEquals((Object)boundAddr, (Object)this.unwrap(ds.getLocalAddress(), 0));
        Assertions.assertEquals((Object)boundAddr, (Object)ds.getLocalSocketAddress());
    }

    private void assertConnectedDatagramSocket(DatagramSocket ds, SocketAddress boundAddr, SocketAddress remoteAddr) throws SocketException {
        Assertions.assertTrue((boolean)ds.isConnected());
        Assertions.assertFalse((boolean)ds.isClosed());
        this.assertRemoteAddress(ds, remoteAddr);
        if (boundAddr != null) {
            this.assertBoundDatagramSocket(ds, boundAddr);
        } else {
            Assertions.assertEquals((int)0, (int)ds.getLocalPort());
        }
    }

    protected void assertRemoteAddress(DatagramSocket ds, SocketAddress remoteAddr) throws SocketException {
        Assertions.assertEquals((Object)remoteAddr, (Object)ds.getRemoteSocketAddress());
    }

    private static void assertDatagramPacketAddress(DatagramPacket dp, SocketAddress addr0) {
        AFSocketAddress addr = (AFSocketAddress)addr0;
        Assertions.assertEquals((Object)addr.wrapAddress(), (Object)dp.getAddress());
        Assertions.assertEquals((Object)new InetSocketAddress(addr.wrapAddress(), addr.getPort()), (Object)dp.getSocketAddress());
        Assertions.assertEquals((int)0, (int)dp.getPort());
    }

    @Test
    public void testBindConnect() throws SocketException, IOException, InterruptedException {
        AFSocketAddress ds1Addr = (AFSocketAddress)this.newTempAddress();
        AFSocketAddress ds2Addr = (AFSocketAddress)this.newTempAddress();
        Assertions.assertNotEquals((Object)ds1Addr, (Object)ds2Addr);
        try (DatagramSocket ds1 = this.newDatagramSocket();
             DatagramSocket ds2 = this.newDatagramSocket();){
            this.assertUnconnectedDatagramSocket(ds1);
            ds1.bind(ds1Addr);
            Assertions.assertNull((Object)ds1.getRemoteSocketAddress());
            this.assertBoundDatagramSocket(ds1, ds1Addr);
            if (!ds2.isBound()) {
                ds2.bind(ds2Addr);
            }
            ds1.connect(ds2Addr);
            this.assertConnectedDatagramSocket(ds1, ds1Addr, ds2Addr);
            byte[] data = "Hello world!".getBytes(StandardCharsets.UTF_8);
            byte[] buf = new byte[512];
            System.arraycopy(data, 0, buf, 0, data.length);
            DatagramPacket dp1 = new DatagramPacket(buf, data.length);
            ds1.send(dp1);
            DatagramPacket dp2 = new DatagramPacket(new byte[1024], 3, 1021);
            dp2.setPort(123);
            ds2.receive(dp2);
            byte[] received = new byte[dp2.getLength()];
            System.arraycopy(dp2.getData(), dp2.getOffset(), received, 0, dp2.getLength());
            Assertions.assertArrayEquals((byte[])data, (byte[])received);
            DatagramSocketTest.assertDatagramPacketAddress(dp2, ds1Addr);
            dp2.setAddress(ds1Addr.wrapAddress());
            ds2.send(dp2);
            dp1.setLength(100);
            ds1.receive(dp1);
            Assertions.assertEquals((int)12, (int)dp1.getLength());
            Assertions.assertEquals((Object)ds2Addr.wrapAddress(), (Object)dp1.getAddress());
            ds1.close();
            DatagramSocketTest.assertClosedDatagramSocket(ds1);
            ds2.close();
            DatagramSocketTest.assertClosedDatagramSocket(ds2);
        }
    }

    @Test
    public void testReadTimeout() throws IOException {
        SocketAddress dsAddr = this.newTempAddress();
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(5L), () -> {
            try (DatagramSocket ds = this.newDatagramSocket();){
                ds.setSoTimeout(50);
                ds.bind(dsAddr);
                Assertions.assertThrows(SocketTimeoutException.class, () -> ds.receive(AFDatagramUtil.datagramWithCapacity(64)));
            }
        });
    }

    @Test
    public void testPeekTimeout() throws IOException {
        SocketAddress dsAddr = this.newTempAddress();
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(5L), () -> {
            try (AFDatagramSocket ds = (AFDatagramSocket)this.newDatagramSocket();){
                ds.setSoTimeout(50);
                ds.bind(dsAddr);
                Assertions.assertThrows(SocketTimeoutException.class, () -> {
                    DatagramPacket dp = AFDatagramUtil.datagramWithCapacity(64);
                    ds.peek(dp);
                });
            }
        });
    }
}

