/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import org.newsclub.net.unix.AFSocket;
import org.newsclub.net.unix.CloseablePair;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public interface AddressSpecifics<A extends SocketAddress> {
    public SocketAddress initServerSocketBindAddress() throws IOException;

    public Socket newStrictSocket() throws IOException;

    public Socket newSocket() throws IOException;

    public DatagramSocket newDatagramSocket() throws IOException;

    public ServerSocket newServerSocket() throws IOException;

    public SocketAddress newTempAddress() throws IOException;

    public SocketAddress unwrap(InetAddress var1, int var2) throws SocketException;

    public SelectorProvider selectorProvider();

    public CloseablePair<? extends SocketChannel> newSocketPair() throws IOException;

    public CloseablePair<? extends DatagramChannel> newDatagramSocketPair() throws IOException;

    public ServerSocket newServerSocketBindOn(SocketAddress var1) throws IOException;

    public Socket connectTo(SocketAddress var1) throws IOException;

    public ServerSocket newServerSocketBindOn(SocketAddress var1, boolean var2) throws IOException;

    default public CloseablePair<? extends Socket> newInterconnectedSockets() throws IOException {
        SocketAddress address = this.newTempAddress();
        ServerSocket server = this.newServerSocketBindOn(address);
        Socket client = this.connectTo(address);
        Socket socket = server.accept();
        return new CloseablePair<AFSocket>((AFSocket)client, (AFSocket)socket, server);
    }

    public DatagramChannel newDatagramChannel() throws IOException;
}

