/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.domain;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import com.kohlschutter.testutil.ForkedVM;
import com.kohlschutter.testutil.ProcessUtilRequirement;
import java.io.BufferedReader;
import java.io.FileDescriptor;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Socket;
import java.net.SocketException;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AFSocketAddress;
import org.newsclub.net.unix.AFSocketCapability;
import org.newsclub.net.unix.AFSocketCapabilityRequirement;
import org.newsclub.net.unix.AFUNIXDatagramChannel;
import org.newsclub.net.unix.AFUNIXServerSocket;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.AFUNIXSocketChannel;
import org.newsclub.net.unix.AFUNIXSocketPair;
import org.newsclub.net.unix.FileDescriptorCast;
import org.newsclub.net.unix.StdinSocketApp;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@AFSocketCapabilityRequirement(value={AFSocketCapability.CAPABILITY_UNIX_DOMAIN})
@SuppressFBWarnings(value={"THROWS_METHOD_THROWS_CLAUSE_THROWABLE", "THROWS_METHOD_THROWS_CLAUSE_BASIC_EXCEPTION"})
public class FileDescriptorCastTest {
    @Test
    @AFSocketCapabilityRequirement(value={AFSocketCapability.CAPABILITY_NATIVE_SOCKETPAIR})
    public void testSocketPair() throws Exception {
        AFUNIXSocketPair<AFUNIXSocketChannel> socketPair = AFUNIXSocketPair.open();
        AFUNIXSocketChannel sock1chan = (AFUNIXSocketChannel)socketPair.getSocket1();
        FileDescriptor sock2fd = ((AFUNIXSocketChannel)socketPair.getSocket2()).getFileDescriptor();
        Assertions.assertTrue((boolean)sock1chan.isConnected());
        FileDescriptorCast fdc = FileDescriptorCast.using(sock2fd);
        Assertions.assertEquals((Object)AFUNIXSocket.supports(AFSocketCapability.CAPABILITY_NATIVE_SOCKETPAIR), (Object)fdc.isAvailable(Socket.class));
        if (!AFUNIXSocket.supports(AFSocketCapability.CAPABILITY_NATIVE_SOCKETPAIR)) {
            FileDescriptorCast.using(sock2fd).as(FileChannel.class);
        } else {
            Socket sock2 = FileDescriptorCast.using(sock2fd).as(Socket.class);
            Assertions.assertEquals(AFUNIXSocket.class, sock2.getClass());
            Assertions.assertTrue((boolean)sock2.isConnected());
            Assertions.assertEquals((Object)sock2fd, (Object)((AFUNIXSocket)sock2).getFileDescriptor());
        }
    }

    @Test
    @AFSocketCapabilityRequirement(value={AFSocketCapability.CAPABILITY_NATIVE_SOCKETPAIR})
    public void testSocketPairNative() throws Exception {
        AFUNIXSocketPair<AFUNIXSocketChannel> socketPair = AFUNIXSocketPair.open();
        AFUNIXSocketChannel sock1chan = (AFUNIXSocketChannel)socketPair.getSocket1();
        FileDescriptor sock2fd = ((AFUNIXSocketChannel)socketPair.getSocket2()).getFileDescriptor();
        Assertions.assertTrue((boolean)sock1chan.isConnected());
        AFUNIXSocketChannel sock2chan = FileDescriptorCast.using(sock2fd).as(AFUNIXSocketChannel.class);
        Assertions.assertEquals((Object)sock2fd, (Object)sock2chan.getFileDescriptor());
        Assertions.assertTrue((boolean)sock2chan.isConnected());
        ByteBuffer bb = ByteBuffer.allocate(32);
        bb.putInt(305419896);
        bb.flip();
        sock1chan.write(bb);
        bb.clear();
        Assertions.assertEquals((int)4, (int)sock2chan.read(bb));
        bb.flip();
        Assertions.assertEquals((int)305419896, (int)bb.getInt());
    }

    @Test
    public void testUnconnectedServerAsSocket() throws Exception {
        try (AFUNIXServerSocket ass = AFUNIXServerSocket.bindOn(AFUNIXSocketAddress.ofNewTempFile(), true);
             AFUNIXServerSocket ass2 = AFUNIXServerSocket.bindOn(AFUNIXSocketAddress.ofNewTempFile(), true);){
            FileDescriptor fd = ass.getFileDescriptor();
            Assertions.assertTrue((boolean)fd.valid());
            AFUNIXSocket sock = FileDescriptorCast.using(fd).as(AFUNIXSocket.class);
            Assertions.assertTrue((boolean)sock.isBound());
            Assertions.assertFalse((boolean)sock.isConnected());
            Assertions.assertThrows(SocketException.class, () -> sock.connect(ass2.getLocalSocketAddress()));
            Assertions.assertThrows(SocketException.class, () -> sock.connect(ass.getLocalSocketAddress()));
            Assertions.assertThrows(SocketException.class, () -> sock.getInputStream().read());
            Assertions.assertNull((Object)sock.getRemoteSocketAddress());
            Assertions.assertFalse((boolean)sock.isConnected());
        }
    }

    @Test
    public void testServer() throws Exception {
        AFUNIXSocketAddress serverAddress = AFUNIXSocketAddress.ofNewTempFile();
        try (AFUNIXServerSocket ass = AFUNIXServerSocket.bindOn(serverAddress, true);
             AFUNIXSocket sock = AFUNIXSocket.connectTo(serverAddress);){
            AFUNIXSocket sock1 = FileDescriptorCast.using(sock.getFileDescriptor()).as(AFUNIXSocket.class);
            Assertions.assertEquals((Object)sock.isBound(), (Object)sock1.isBound());
            Assertions.assertEquals((Object)sock.isConnected(), (Object)sock1.isConnected());
            Assertions.assertTrue((boolean)sock1.isConnected());
            Assertions.assertEquals((Object)sock.getRemoteSocketAddress(), (Object)sock1.getRemoteSocketAddress());
            Assertions.assertEquals((Object)ass.getLocalSocketAddress(), (Object)sock.getRemoteSocketAddress());
            AFUNIXServerSocket serverSock = FileDescriptorCast.using(ass.getFileDescriptor()).as(AFUNIXServerSocket.class);
            AFUNIXSocket sock0 = serverSock.accept();
            Assertions.assertEquals((Object)ass.getLocalSocketAddress(), (Object)sock0.getLocalSocketAddress());
            sock0.getOutputStream().write(23);
            Assertions.assertEquals((int)23, (int)sock1.getInputStream().read());
        }
    }

    @Test
    @AFSocketCapabilityRequirement(value={AFSocketCapability.CAPABILITY_UNIX_DATAGRAMS})
    public void testDatagramSocket() throws Exception {
        AFUNIXSocketAddress addr1 = AFUNIXSocketAddress.ofNewTempFile();
        AFUNIXSocketAddress addr2 = AFUNIXSocketAddress.ofNewTempFile();
        try (AFUNIXDatagramChannel dc1 = AFUNIXDatagramChannel.open();
             AFUNIXDatagramChannel dc2 = AFUNIXDatagramChannel.open();){
            dc1.setDeleteOnClose(true);
            dc2.setDeleteOnClose(true);
            ByteBuffer bb = ByteBuffer.allocate(32);
            bb.putInt(1234);
            bb.flip();
            dc1.getOption(StandardSocketOptions.SO_SNDBUF);
            AFUNIXDatagramChannel dc1c = FileDescriptorCast.using(dc1.getFileDescriptor()).as(AFUNIXDatagramChannel.class);
            AFUNIXDatagramChannel dc2c = FileDescriptorCast.using(dc2.getFileDescriptor()).as(AFUNIXDatagramChannel.class);
            Assertions.assertFalse((boolean)dc1.isBound());
            Assertions.assertFalse((boolean)dc1c.isBound());
            Assertions.assertFalse((boolean)dc2.isBound());
            Assertions.assertFalse((boolean)dc2c.isBound());
            dc1.bind(addr1);
            dc2.bind(addr2);
            Assertions.assertTrue((boolean)dc1.isBound());
            Assertions.assertTrue((boolean)dc1c.isBound());
            Assertions.assertTrue((boolean)dc2.isBound());
            Assertions.assertTrue((boolean)dc2c.isBound());
            Assertions.assertEquals((Object)dc1.getLocalAddress(), (Object)dc1c.getLocalAddress());
            Assertions.assertEquals((Object)dc2.getLocalAddress(), (Object)dc2c.getLocalAddress());
            dc1c.connect(addr2);
            dc2c.connect(addr1);
            Assertions.assertTrue((boolean)dc1c.isConnected());
            Assertions.assertTrue((boolean)dc1.isConnected());
            Assertions.assertEquals((Object)dc1.getLocalAddress(), (Object)dc2c.getRemoteAddress());
            Assertions.assertEquals((Object)dc1.getRemoteAddress(), (Object)dc2c.getLocalAddress());
            Assertions.assertEquals((Object)dc1c.getLocalAddress(), (Object)dc2.getRemoteAddress());
            Assertions.assertEquals((Object)dc1c.getRemoteAddress(), (Object)dc2.getLocalAddress());
            Assertions.assertEquals((int)4, (int)dc1c.write(bb));
            bb.clear();
            Assertions.assertEquals((int)4, (int)dc2c.read(bb));
            bb.flip();
            Assertions.assertEquals((int)1234, (int)bb.getInt());
        }
    }

    @Test
    public void testSocketPorts() throws Exception {
        AFUNIXSocketAddress addr = AFUNIXSocketAddress.ofNewTempPath(123);
        try (AFUNIXServerSocket ass = AFUNIXServerSocket.bindOn(addr);){
            Assertions.assertEquals((int)123, (int)ass.getLocalPort());
            AFUNIXServerSocket ass1 = FileDescriptorCast.using(ass.getFileDescriptor()).withLocalPort(123).as(AFUNIXServerSocket.class);
            Assertions.assertEquals((int)123, (int)ass.getLocalPort());
            AFUNIXSocket socket = AFUNIXSocket.connectTo(addr);
            Assertions.assertEquals((int)123, (int)((AFUNIXSocketAddress)socket.getRemoteSocketAddress()).getPort());
            AFUNIXSocket socket1 = FileDescriptorCast.using(socket.getFileDescriptor()).withRemotePort(123).as(AFUNIXSocket.class);
            Assertions.assertEquals((Object)socket.getRemoteSocketAddress(), (Object)socket1.getRemoteSocketAddress());
            Assertions.assertEquals((int)123, (int)((AFUNIXSocketAddress)socket1.getRemoteSocketAddress()).getPort());
            AFUNIXSocket ss = ass1.accept();
            Assertions.assertEquals((int)123, (int)ss.getLocalPort());
            Assertions.assertEquals((int)123, (int)((AFUNIXSocketAddress)ss.getLocalSocketAddress()).getPort());
        }
    }

    private int getPort(AFSocketAddress addr) {
        if (addr == null) {
            return -1;
        }
        return addr.getPort();
    }

    @Test
    @AFSocketCapabilityRequirement(value={AFSocketCapability.CAPABILITY_UNIX_DATAGRAMS})
    public void testDatagramPorts() throws Exception {
        AFUNIXSocketAddress addr = AFUNIXSocketAddress.ofNewTempPath(123);
        Assertions.assertEquals((int)123, (int)addr.getPort());
        try (AFUNIXDatagramChannel dc1 = AFUNIXDatagramChannel.open();
             AFUNIXDatagramChannel dc2 = AFUNIXDatagramChannel.open();){
            dc1.setDeleteOnClose(true);
            dc2.setDeleteOnClose(true);
            Assertions.assertNull((Object)dc1.getLocalAddress());
            Assertions.assertNull((Object)dc1.getRemoteAddress());
            Assertions.assertNull((Object)dc2.getLocalAddress());
            Assertions.assertNull((Object)dc2.getRemoteAddress());
            dc1.bind(addr);
            dc2.connect(addr);
            Assertions.assertEquals((Object)dc1.getLocalAddress(), (Object)dc2.getRemoteAddress());
            Assertions.assertEquals((int)123, (int)this.getPort((AFSocketAddress)dc1.getLocalAddress()));
            AFUNIXDatagramChannel dc1c = FileDescriptorCast.using(dc1.getFileDescriptor()).as(AFUNIXDatagramChannel.class);
            AFUNIXDatagramChannel dc2c = FileDescriptorCast.using(dc2.getFileDescriptor()).as(AFUNIXDatagramChannel.class);
            Assertions.assertEquals((int)0, (int)this.getPort((AFSocketAddress)dc1c.getLocalAddress()));
            Assertions.assertEquals((int)0, (int)this.getPort((AFSocketAddress)dc2c.getRemoteAddress()));
            dc1c = FileDescriptorCast.using(dc1.getFileDescriptor()).withLocalPort(123).as(AFUNIXDatagramChannel.class);
            dc2c = FileDescriptorCast.using(dc2.getFileDescriptor()).withRemotePort(123).as(AFUNIXDatagramChannel.class);
            Assertions.assertEquals((int)123, (int)this.getPort((AFSocketAddress)dc1c.getLocalAddress()));
            Assertions.assertEquals((int)123, (int)this.getPort((AFSocketAddress)dc2c.getRemoteAddress()));
        }
    }

    @Test
    @AFSocketCapabilityRequirement(value={AFSocketCapability.CAPABILITY_UNIX_DATAGRAMS})
    public void testDatagramFileChannel() throws Exception {
        AFUNIXSocketAddress addr = AFUNIXSocketAddress.ofNewTempPath(123);
        try (AFUNIXDatagramChannel dc1 = AFUNIXDatagramChannel.open();
             AFUNIXDatagramChannel dc2 = AFUNIXDatagramChannel.open();){
            dc1.setDeleteOnClose(true);
            dc2.setDeleteOnClose(true);
            dc1.bind(addr);
            dc2.connect(addr);
            FileDescriptorCast fdc1 = FileDescriptorCast.using(dc1.getFileDescriptor());
            Assertions.assertTrue((boolean)fdc1.isAvailable(DatagramChannel.class));
            Assertions.assertTrue((boolean)fdc1.isAvailable(AFUNIXDatagramChannel.class));
            Assertions.assertTrue((boolean)fdc1.isAvailable(FileChannel.class));
            Assertions.assertTrue((boolean)fdc1.availableTypes().contains(ReadableByteChannel.class));
            Assertions.assertTrue((boolean)fdc1.availableTypes().contains(WritableByteChannel.class));
            FileChannel fc = fdc1.as(FileChannel.class);
            ByteBuffer bb = ByteBuffer.allocate(4);
            bb.putInt(305419896);
            bb.flip();
            dc2.write(bb);
            bb.clear();
            Assertions.assertEquals((int)4, (int)fc.read(bb));
            bb.flip();
            Assertions.assertEquals((int)305419896, (int)bb.getInt());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @AFSocketCapabilityRequirement(value={AFSocketCapability.CAPABILITY_FD_AS_REDIRECT})
    @ProcessUtilRequirement(canGetJavaCommandArguments=true)
    public void testForkedVMRedirectStdin() throws Exception {
        AFUNIXSocketAddress addr = AFUNIXSocketAddress.ofNewTempFile();
        try (AFUNIXServerSocket serverSocket = AFUNIXServerSocket.bindOn(addr);
             AFUNIXSocket clientConn = AFUNIXSocket.connectTo(addr);
             AFUNIXSocket serverConn = serverSocket.accept();){
            Assertions.assertTrue((boolean)addr.getFile().delete());
            ForkedVM vm = new ForkedVM(StdinSocketApp.class);
            vm.setRedirectInput(FileDescriptorCast.using(clientConn.getFileDescriptor()).as(ProcessBuilder.Redirect.class));
            vm.setRedirectError(ProcessBuilder.Redirect.INHERIT);
            Process p = vm.fork();
            try {
                try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)serverConn.getInputStream(), StandardCharsets.UTF_8));){
                    Assertions.assertEquals((Object)"Hello world", (Object)br.readLine());
                    String l = br.readLine();
                    if (l != null) {
                        Assertions.fail((String)("Unexpected output: " + l));
                    }
                }
                Assertions.assertTrue((boolean)p.waitFor(30L, TimeUnit.SECONDS));
                Assertions.assertEquals((int)0, (int)p.exitValue());
            }
            finally {
                p.destroyForcibly();
            }
        }
    }
}

