/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import com.kohlschutter.testutil.CommandAvailabilityRequirement;
import com.kohlschutter.testutil.ForkedVM;
import com.kohlschutter.testutil.ForkedVMRequirement;
import com.kohlschutter.util.ExceptionUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Semaphore;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AFSocketAddress;
import org.newsclub.net.unix.AddressSpecifics;
import org.newsclub.net.unix.FinalizeTestClient;
import org.newsclub.net.unix.SocketTestBase;
import org.opentest4j.TestAbortedException;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@CommandAvailabilityRequirement(commands={"lsof"})
@ForkedVMRequirement(forkSupported=true)
@SuppressFBWarnings(value={"THROWS_METHOD_THROWS_CLAUSE_THROWABLE", "THROWS_METHOD_THROWS_CLAUSE_BASIC_EXCEPTION"})
public abstract class FinalizeTest<A extends SocketAddress>
extends SocketTestBase<A> {
    private Process process = null;

    protected FinalizeTest(AddressSpecifics<A> asp) {
        super(asp);
    }

    @Test
    public void testLeak() throws Exception {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(10L), () -> {
            final Semaphore sema = new Semaphore(0);
            final CompletableFuture future = new CompletableFuture();
            try (SocketTestBase.ServerThread serverThread = new SocketTestBase.ServerThread(){

                @Override
                protected void onServerReady() {
                    sema.release();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void handleConnection(Socket socket) throws IOException {
                    try {
                        Assumptions.assumeTrue((FinalizeTest.this.process.pid() > 0L ? 1 : 0) != 0);
                        int linesBefore = -1;
                        try (OutputStream out = socket.getOutputStream();
                             InputStream in = socket.getInputStream();){
                            linesBefore = FinalizeTest.lsofUnixSockets(FinalizeTest.this.process.pid());
                            out.write(64);
                            Assumptions.assumeTrue((linesBefore > 0 ? 1 : 0) != 0);
                        }
                        finally {
                            future.complete(linesBefore);
                        }
                    }
                    catch (Exception e) {
                        future.completeExceptionally(e);
                    }
                    finally {
                        this.stopAcceptingConnections();
                    }
                }
            };){
                sema.acquire();
                this.process = this.launchServerProcess(this.socketType(), ((AFSocketAddress)serverThread.getServerAddress()).getHostString());
                Integer linesBefore = (Integer)future.get();
                Assertions.assertNotNull((Object)linesBefore);
                try {
                    int linesAfter = 0;
                    for (int i = 0; i < 10; ++i) {
                        Thread.sleep(100L);
                        linesAfter = FinalizeTest.lsofUnixSockets(this.process.pid());
                        if (linesAfter != linesBefore || !this.process.isAlive()) break;
                    }
                    Assumptions.assumeTrue((linesAfter > 0 ? 1 : 0) != 0, (String)"lsof may fail to return anything");
                    Assertions.assertTrue((linesAfter < linesBefore ? 1 : 0) != 0, (String)"Our unix socket file handle should have been cleared out");
                }
                finally {
                    this.process.destroy();
                    this.process.waitFor();
                }
            }
            catch (ExecutionException e) {
                throw ExceptionUtil.unwrapExecutionException((ExecutionException)e);
            }
            finally {
                Process p = this.process;
                if (p != null) {
                    p.destroy();
                }
                this.process = null;
            }
        });
    }

    private Process launchServerProcess(final String socketType, final String socketPath) throws IOException {
        ForkedVM vm = new ForkedVM(){

            protected void onJavaMainClass(String arg) {
                super.onJavaOption("-Dtest.junixsocket.socket.type=" + socketType);
                super.onJavaOption("-Dtest.junixsocket.socket=" + socketPath);
                super.onJavaMainClass(FinalizeTestClient.class.getName());
            }

            protected void onArguments(List<String> args) {
                super.onArguments(Collections.emptyList());
            }
        };
        vm.setRedirectError(ProcessBuilder.Redirect.INHERIT);
        vm.setRedirectOutput(ProcessBuilder.Redirect.INHERIT);
        return vm.fork();
    }

    @SuppressFBWarnings(value={"RV_DONT_JUST_NULL_CHECK_READLINE"})
    private static int lsofUnixSockets(long pid) throws IOException, TestAbortedException, InterruptedException {
        Process p;
        Assertions.assertTrue((pid > 0L ? 1 : 0) != 0);
        try {
            p = Runtime.getRuntime().exec(new String[]{"lsof", "-U", "-a", "-p", String.valueOf(pid)});
        }
        catch (Exception e) {
            Assumptions.assumeTrue((boolean)false, (String)e.getMessage());
            return -1;
        }
        int lines = 0;
        try (BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream(), Charset.defaultCharset()));){
            String l;
            while ((l = in.readLine()) != null) {
                ++lines;
                if (!l.contains("busybox")) continue;
                Assumptions.assumeTrue((boolean)false, (String)"incompatible lsof binary");
            }
        }
        Assumptions.assumeTrue((p.waitFor() == 0 ? 1 : 0) != 0, (String)"lsof should terminate with RC=0");
        return lines;
    }

    protected abstract String socketType();
}

