/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import com.kohlschutter.util.IOUtil;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.time.Duration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AFPipe;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.FileDescriptorCast;
import org.opentest4j.AssertionFailedError;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@SuppressFBWarnings(value={"THROWS_METHOD_THROWS_CLAUSE_THROWABLE", "THROWS_METHOD_THROWS_CLAUSE_BASIC_EXCEPTION"})
public class FileDescriptorCastTest {
    @Test
    public void testInvalidFileDescriptor() throws IOException {
        Assertions.assertThrows(IOException.class, () -> FileDescriptorCast.using(new FileDescriptor()));
        Assertions.assertThrows(NullPointerException.class, () -> FileDescriptorCast.using(null));
    }

    @Test
    public void testStdout() throws IOException {
        FileDescriptorCast fdc = FileDescriptorCast.using(FileDescriptor.out);
        Assertions.assertThrows(ClassCastException.class, () -> fdc.as(Socket.class));
        Assertions.assertThrows(ClassCastException.class, () -> fdc.as(AFUNIXSocket.class));
        Assertions.assertThrows(NullPointerException.class, () -> fdc.as(null));
        Assertions.assertEquals((Object)fdc.getFileDescriptor(), (Object)fdc.as(Object.class));
        Assertions.assertEquals((Object)fdc.getFileDescriptor(), (Object)fdc.as(FileDescriptor.class));
        Assertions.assertEquals(fdc.as(OutputStream.class).getClass(), fdc.as(FileOutputStream.class).getClass());
        Assertions.assertEquals(fdc.as(InputStream.class).getClass(), fdc.as(FileInputStream.class).getClass());
        try {
            Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(100L), () -> {
                try {
                    fdc.as(InputStream.class).read();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }
        catch (AssertionFailedError assertionFailedError) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRandomAccessFile() throws Exception {
        File tempFile = AFUNIXSocketAddress.newTempPath(false);
        try (RandomAccessFile raf = new RandomAccessFile(tempFile, "rw");
             FileChannel fc = FileDescriptorCast.using(raf.getFD()).as(FileChannel.class);){
            ByteBuffer bb = ByteBuffer.allocate(4);
            bb.putInt(305419896);
            bb.flip();
            fc.write(bb);
            Assertions.assertEquals((long)4L, (long)raf.length());
            Assertions.assertEquals((long)4L, (long)raf.getFilePointer());
            raf.seek(2L);
            Assertions.assertEquals((long)2L, (long)fc.position());
            bb.clear();
            Assertions.assertEquals((int)2, (int)fc.read(bb));
            Assertions.assertEquals((int)22136, (int)bb.getShort());
        }
        finally {
            IOUtil.delete((File)tempFile);
        }
    }

    @Test
    public void testPipe() throws Exception {
        try (AFPipe pipe = AFPipe.open();
             AFPipe.SourceChannel source = pipe.source();
             AFPipe.SinkChannel sink = pipe.sink();){
            ByteBuffer buf = ByteBuffer.allocate(32);
            buf.order(ByteOrder.LITTLE_ENDIAN);
            buf.putInt(61183);
            buf.flip();
            Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(5L), () -> {
                sink.write(buf);
                OutputStream badOut = FileDescriptorCast.using(source.getFileDescriptor()).as(OutputStream.class);
                try {
                    badOut.write(34);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                FileDescriptorCast fdc = FileDescriptorCast.using(source.getFileDescriptor());
                InputStream in = fdc.as(InputStream.class);
                int available = in.available();
                if (available != 0) {
                    Assertions.assertEquals((int)4, (int)available);
                }
                Assertions.assertEquals((int)255, (int)in.read());
                Assertions.assertEquals((int)238, (int)in.read());
                Assertions.assertEquals((int)0, (int)in.read());
                Assertions.assertEquals((int)0, (int)in.read());
                OutputStream out = FileDescriptorCast.using(sink.getFileDescriptor()).as(OutputStream.class);
                out.write(34);
                out.write(51);
                buf.clear();
                int numRead = source.read(buf);
                Assertions.assertEquals((int)2, (int)numRead);
                buf.flip();
                Assertions.assertEquals((int)13090, (int)buf.getShort());
            });
        }
    }
}

