/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.selftest;

import com.kohlschutter.util.ConsolePrintStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.junit.platform.console.options.Theme;
import org.junit.platform.console.tasks.JuxPackageAccess;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;
import org.junit.platform.launcher.listeners.SummaryGeneratingListener;
import org.junit.platform.launcher.listeners.TestExecutionSummary;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class SelftestExecutor {
    private final List<Class<?>> testClasses;
    private final String prefix;

    SelftestExecutor(List<Class<?>> testClasses, String prefix) {
        this.testClasses = testClasses;
        this.prefix = prefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TestExecutionSummary execute(final ConsolePrintStream out0) throws Exception {
        PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)out0, Charset.defaultCharset()));
        try {
            Launcher launcher = LauncherFactory.create();
            SummaryGeneratingListener summaryListener = new SummaryGeneratingListener();
            launcher.registerTestExecutionListeners(new TestExecutionListener[]{summaryListener, JuxPackageAccess.newTreePrintingListener(out, true, Theme.ASCII)});
            LauncherDiscoveryRequestBuilder requestBuilder = LauncherDiscoveryRequestBuilder.request();
            requestBuilder.configurationParameter("junit.jupiter.execution.timeout.testable.method.default", System.getProperty("selftest.test-timeout", "10 s"));
            requestBuilder.selectors(this.testClasses.stream().map(DiscoverySelectors::selectClass).collect(Collectors.toList()));
            LauncherDiscoveryRequest discoveryRequest = requestBuilder.build();
            TestPlan testPlan = launcher.discover(discoveryRequest);
            launcher.execute(testPlan, new TestExecutionListener[]{new TestExecutionListener(){
                final Map<String, TestIdentifier> tids = new HashMap<String, TestIdentifier>();

                public void executionStarted(TestIdentifier tid) {
                    this.tids.put(tid.getUniqueId(), tid);
                    Optional pid = tid.getParentId();
                    if (tid.getType().isTest() && pid.isPresent()) {
                        out0.update(SelftestExecutor.this.prefix + this.tids.get(pid.get()).getDisplayName() + "." + tid.getDisplayName() + "... ");
                    }
                }

                public void executionFinished(TestIdentifier tid, TestExecutionResult testExecutionResult) {
                    this.tids.remove(tid.getUniqueId());
                    if (!tid.getParentId().isPresent()) {
                        out0.updateln(SelftestExecutor.this.prefix + "done");
                    }
                }
            }});
            TestExecutionSummary summary = summaryListener.getSummary();
            summary.printFailuresTo(out);
            summary.printTo(out);
            TestExecutionSummary testExecutionSummary = summary;
            return testExecutionSummary;
        }
        finally {
            out.flush();
        }
    }
}

