/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import com.kohlschutter.util.IOUtil;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.time.Duration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AFUNIXDatagramSocket;
import org.newsclub.net.unix.AFUNIXDatagramUtil;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.AFUNIXSocketCapability;
import org.newsclub.net.unix.AFUNIXSocketCapabilityRequirement;
import org.newsclub.net.unix.SocketTestBase;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@AFUNIXSocketCapabilityRequirement(value={AFUNIXSocketCapability.CAPABILITY_FILE_DESCRIPTORS})
public class FileDescriptorsTest
extends SocketTestBase {
    @Test
    public void testSendRecvFileDescriptors() throws Exception {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(2L), () -> {
            try (SocketTestBase.ServerThread serverThread = new SocketTestBase.ServerThread(){

                @Override
                protected void handleConnection(AFUNIXSocket socket) throws IOException {
                    socket.setOutboundFileDescriptors(new FileDescriptor[]{FileDescriptor.in, FileDescriptor.err});
                    Assertions.assertTrue((boolean)socket.hasOutboundFileDescriptors());
                    try (OutputStream outputStream = socket.getOutputStream();){
                        outputStream.write("HELLO".getBytes("UTF-8"));
                    }
                    Assertions.assertFalse((boolean)socket.hasOutboundFileDescriptors());
                    this.stopAcceptingConnections();
                }
            };
                 AFUNIXSocket socket = this.connectToServer();
                 InputStream in = socket.getInputStream();){
                socket.setAncillaryReceiveBufferSize(1024);
                byte[] buf = new byte[64];
                FileDescriptor[] fds = socket.getReceivedFileDescriptors();
                Assertions.assertNull((Object)fds, (String)"Initially, there are no file descriptors");
                int numRead = in.read(buf);
                Assertions.assertEquals((int)5, (int)numRead, (String)"'HELLO' is five bytes long");
                Assertions.assertEquals((Object)"HELLO", (Object)new String(buf, 0, numRead, "UTF-8"));
                fds = socket.getReceivedFileDescriptors();
                Assertions.assertEquals((int)2, (int)fds.length, (String)"Now, we should have two file descriptors");
                fds = socket.getReceivedFileDescriptors();
                Assertions.assertNull((Object)fds, (String)"If we ask again, these new file descriptors should be gone");
                try (InputStream is = socket.getInputStream();){
                    numRead = is.read(buf);
                    Assertions.assertEquals((int)-1, (int)numRead, (String)"There shouldn't be anything left to read");
                    fds = socket.getReceivedFileDescriptors();
                    Assertions.assertNull((Object)fds, (String)"There shouldn't be any new file descriptors");
                }
            }
        });
    }

    @Test
    public void testNullFileDescriptorArray() throws Exception {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(2L), () -> {
            try (SocketTestBase.ServerThread serverThread = new SocketTestBase.ServerThread(){

                @Override
                protected void handleConnection(AFUNIXSocket socket) throws IOException {
                    socket.setOutboundFileDescriptors((FileDescriptor[])null);
                    try (OutputStream outputStream = socket.getOutputStream();){
                        outputStream.write(123);
                    }
                    this.stopAcceptingConnections();
                }
            };
                 AFUNIXSocket socket = this.connectToServer();){
                socket.setAncillaryReceiveBufferSize(1024);
                try (InputStream inputStream = socket.getInputStream();){
                    inputStream.read();
                }
            }
        });
    }

    @Test
    public void testEmptyFileDescriptorArray() throws Exception {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(2L), () -> {
            try (SocketTestBase.ServerThread serverThread = new SocketTestBase.ServerThread(){

                @Override
                protected void handleConnection(AFUNIXSocket socket) throws IOException {
                    socket.setOutboundFileDescriptors(new FileDescriptor[0]);
                    try (OutputStream outputStream = socket.getOutputStream();){
                        outputStream.write(123);
                    }
                    this.stopAcceptingConnections();
                }
            };
                 AFUNIXSocket socket = this.connectToServer();){
                socket.setAncillaryReceiveBufferSize(1024);
                try (InputStream inputStream = socket.getInputStream();){
                    inputStream.read();
                }
            }
        });
    }

    @Test
    public void testBadFileDescriptor() throws Exception {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(2L), () -> {
            try (SocketTestBase.ServerThread serverThread = new SocketTestBase.ServerThread(){

                @Override
                protected void handleConnection(AFUNIXSocket socket) throws IOException {
                    socket.setOutboundFileDescriptors(new FileDescriptor[]{new FileDescriptor()});
                    try {
                        try (OutputStream outputStream = socket.getOutputStream();){
                            outputStream.write(123);
                        }
                        Assertions.fail((String)"Expected a \"Bad file descriptor\" SocketException");
                    }
                    catch (SocketException socketException) {
                        // empty catch block
                    }
                    this.stopAcceptingConnections();
                }
            };
                 AFUNIXSocket socket = this.connectToServer();){
                socket.setAncillaryReceiveBufferSize(1024);
                try (InputStream inputStream = socket.getInputStream();){
                    inputStream.read();
                }
            }
        });
    }

    @Test
    public void testNoAncillaryReceiveBuffer() throws Exception {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(2L), () -> {
            try (SocketTestBase.ServerThread serverThread = new SocketTestBase.ServerThread(){

                @Override
                protected void handleConnection(AFUNIXSocket socket) throws IOException {
                    socket.setOutboundFileDescriptors(new FileDescriptor[]{FileDescriptor.in, FileDescriptor.err});
                    try (OutputStream outputStream = socket.getOutputStream();){
                        outputStream.write(123);
                    }
                    this.stopAcceptingConnections();
                }
            };
                 AFUNIXSocket socket = this.connectToServer();
                 InputStream inputStream = socket.getInputStream();){
                try {
                    Assertions.assertEquals((int)123, (int)inputStream.read());
                }
                catch (SocketException socketException) {
                    // empty catch block
                }
                Assertions.assertNull((Object)socket.getReceivedFileDescriptors());
                Assertions.assertEquals((int)0, (int)socket.getAncillaryReceiveBufferSize());
            }
        });
    }

    @Test
    public void testAncillaryReceiveBufferTooSmall() throws Exception {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(2L), () -> {
            try (SocketTestBase.ServerThread serverThread = new SocketTestBase.ServerThread(){

                @Override
                protected void handleConnection(AFUNIXSocket socket) throws IOException {
                    socket.setOutboundFileDescriptors(new FileDescriptor[]{FileDescriptor.in, FileDescriptor.err});
                    Assertions.assertTrue((boolean)socket.hasOutboundFileDescriptors());
                    try (OutputStream outputStream = socket.getOutputStream();){
                        outputStream.write(123);
                    }
                    Assertions.assertFalse((boolean)socket.hasOutboundFileDescriptors());
                    this.stopAcceptingConnections();
                }
            };
                 AFUNIXSocket socket = this.connectToServer();
                 InputStream inputStream = socket.getInputStream();){
                socket.getAFImpl().ancillaryDataSupport.setAncillaryReceiveBufferSize0(13);
                try {
                    Assertions.assertEquals((int)123, (int)inputStream.read());
                    FileDescriptor[] fds = socket.getReceivedFileDescriptors();
                    if (fds != null) {
                        if (fds.length != 2) {
                            if (fds.length == 1) {
                                System.err.println("WARNING: Not all file descriptors were received");
                            } else {
                                Assertions.assertEquals((int)2, (int)fds.length, (String)"Received wrong number of file descriptors");
                            }
                        }
                    } else {
                        Assertions.fail((String)"Expected a \"No buffer space available\" SocketException");
                    }
                }
                catch (SocketException socketException) {
                    // empty catch block
                }
                Assertions.assertNull((Object)socket.getReceivedFileDescriptors());
            }
        });
    }

    @Test
    public void testFileInputStream() throws Exception {
        final File tmpFile = SocketTestBase.newTempFile();
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(2L), () -> {
            try (SocketTestBase.ServerThread serverThread = new SocketTestBase.ServerThread(){

                @Override
                protected void handleConnection(AFUNIXSocket socket) throws IOException {
                    try (FileOutputStream fos = new FileOutputStream(tmpFile);){
                        fos.write("WORLD!".getBytes("UTF-8"));
                    }
                    try (FileInputStream fin = new FileInputStream(tmpFile);){
                        socket.setOutboundFileDescriptors(new FileDescriptor[]{fin.getFD()});
                        try (OutputStream outputStream = socket.getOutputStream();){
                            outputStream.write("HELLO".getBytes("UTF-8"));
                        }
                    }
                    this.stopAcceptingConnections();
                }
            };
                 AFUNIXSocket socket = this.connectToServer();
                 InputStream in = socket.getInputStream();){
                socket.setAncillaryReceiveBufferSize(1024);
                byte[] buf = new byte[64];
                int numRead = in.read(buf);
                Assertions.assertEquals((int)5, (int)numRead, (String)"'HELLO' is five bytes long");
                Assertions.assertEquals((Object)"HELLO", (Object)new String(buf, 0, numRead, "UTF-8"));
                FileDescriptor[] fds = socket.getReceivedFileDescriptors();
                Assertions.assertEquals((int)1, (int)fds.length, (String)"Now, we should have two file descriptors");
                FileDescriptor fdesc = fds[0];
                try (FileInputStream fin = new FileInputStream(fdesc);){
                    numRead = fin.read(buf);
                    Assertions.assertEquals((int)6, (int)numRead, (String)"'WORLD!' is six bytes long");
                    Assertions.assertEquals((Object)"WORLD!", (Object)new String(buf, 0, numRead, "UTF-8"));
                }
            }
            finally {
                Files.deleteIfExists(tmpFile.toPath());
            }
        });
    }

    @Test
    public void testFileInputStreamPartiallyConsumed() throws Exception {
        final File tmpFile = SocketTestBase.newTempFile();
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(2L), () -> {
            try (SocketTestBase.ServerThread serverThread = new SocketTestBase.ServerThread(){

                @Override
                protected void handleConnection(AFUNIXSocket socket) throws IOException {
                    try (FileOutputStream fos = new FileOutputStream(tmpFile);){
                        fos.write("WORLD!".getBytes("UTF-8"));
                    }
                    try (FileInputStream fin = new FileInputStream(tmpFile);){
                        Assertions.assertEquals((int)87, (int)fin.read());
                        socket.setOutboundFileDescriptors(new FileDescriptor[]{fin.getFD()});
                        try (OutputStream outputStream = socket.getOutputStream();){
                            outputStream.write("HELLO".getBytes("UTF-8"));
                        }
                    }
                    this.stopAcceptingConnections();
                }
            };
                 AFUNIXSocket socket = this.connectToServer();
                 InputStream in = socket.getInputStream();){
                socket.setAncillaryReceiveBufferSize(1024);
                byte[] buf = new byte[64];
                int numRead = in.read(buf);
                Assertions.assertEquals((int)5, (int)numRead, (String)"'HELLO' is five bytes long");
                Assertions.assertEquals((Object)"HELLO", (Object)new String(buf, 0, numRead, "UTF-8"));
                FileDescriptor[] fds = socket.getReceivedFileDescriptors();
                Assertions.assertEquals((int)1, (int)fds.length, (String)"Now, we should have two file descriptors");
                FileDescriptor fdesc = fds[0];
                try (FileInputStream fin = new FileInputStream(fdesc);){
                    numRead = fin.read(buf);
                    Assertions.assertEquals((int)5, (int)numRead, (String)"'ORLD!' is five bytes long");
                    Assertions.assertEquals((Object)"ORLD!", (Object)new String(buf, 0, numRead, "UTF-8"));
                }
            }
            finally {
                Files.deleteIfExists(tmpFile.toPath());
            }
        });
    }

    @Test
    public void testDatagramSocket() throws Exception {
        AFUNIXSocketAddress ds1Addr = AFUNIXSocketAddress.of((File)FileDescriptorsTest.newTempFile());
        AFUNIXSocketAddress ds2Addr = AFUNIXSocketAddress.of((File)FileDescriptorsTest.newTempFile());
        try (AFUNIXDatagramSocket ds1 = AFUNIXDatagramSocket.newInstance();
             AFUNIXDatagramSocket ds2 = AFUNIXDatagramSocket.newInstance();){
            ds1.setAncillaryReceiveBufferSize(1024);
            ds2.setAncillaryReceiveBufferSize(1024);
            ds1.bind((SocketAddress)ds1Addr);
            ds2.bind((SocketAddress)ds2Addr);
            ds1.connect((SocketAddress)ds2Addr);
            ds2.connect((SocketAddress)ds1Addr);
            File tmpOut = FileDescriptorsTest.newTempFile();
            try (FileOutputStream fos = new FileOutputStream(tmpOut);){
                ds1.setOutboundFileDescriptors(new FileDescriptor[]{fos.getFD()});
                DatagramPacket dp = AFUNIXDatagramUtil.datagramWithCapacity((int)64);
                Assertions.assertTrue((boolean)ds1.hasOutboundFileDescriptors());
                ds1.send(dp);
                Assertions.assertFalse((boolean)ds1.hasOutboundFileDescriptors());
                ds2.receive(dp);
                FileDescriptor[] fds = ds2.getReceivedFileDescriptors();
                Assertions.assertEquals((int)1, (int)fds.length);
                try (FileOutputStream fos2 = new FileOutputStream(fds[0]);){
                    fos.write("Hello".getBytes(StandardCharsets.UTF_8));
                }
                fos.write("World".getBytes(StandardCharsets.UTF_8));
            }
            try (FileInputStream fin = new FileInputStream(tmpOut);){
                String text = new String(IOUtil.readAllBytes((InputStream)fin), StandardCharsets.UTF_8);
                Assertions.assertEquals((Object)"HelloWorld", (Object)text);
            }
        }
    }
}

