/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import com.kohlschutter.util.IOUtil;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.DatagramChannel;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.time.Duration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AFUNIXDatagramChannel;
import org.newsclub.net.unix.AFUNIXPipe;
import org.newsclub.net.unix.AFUNIXServerSocket;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.AFUNIXSocketCapability;
import org.newsclub.net.unix.AFUNIXSocketCapabilityRequirement;
import org.newsclub.net.unix.AFUNIXSocketChannel;
import org.newsclub.net.unix.AFUNIXSocketPair;
import org.newsclub.net.unix.FileDescriptorCast;
import org.opentest4j.AssertionFailedError;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class FileDescriptorCastTest {
    @Test
    public void testInvalidFileDescriptor() throws IOException {
        Assertions.assertThrows(IOException.class, () -> FileDescriptorCast.using((FileDescriptor)new FileDescriptor()));
        Assertions.assertThrows(NullPointerException.class, () -> FileDescriptorCast.using(null));
    }

    @Test
    public void testStdout() throws IOException {
        FileDescriptorCast fdc = FileDescriptorCast.using((FileDescriptor)FileDescriptor.out);
        Assertions.assertThrows(ClassCastException.class, () -> fdc.as(Socket.class));
        Assertions.assertThrows(ClassCastException.class, () -> fdc.as(AFUNIXSocket.class));
        Assertions.assertThrows(NullPointerException.class, () -> fdc.as(null));
        Assertions.assertEquals((Object)fdc.getFileDescriptor(), (Object)fdc.as(Object.class));
        Assertions.assertEquals((Object)fdc.getFileDescriptor(), (Object)fdc.as(FileDescriptor.class));
        Assertions.assertEquals(((OutputStream)fdc.as(OutputStream.class)).getClass(), ((FileOutputStream)fdc.as(FileOutputStream.class)).getClass());
        Assertions.assertEquals(((InputStream)fdc.as(InputStream.class)).getClass(), ((FileInputStream)fdc.as(FileInputStream.class)).getClass());
        try {
            Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(100L), () -> {
                try {
                    ((InputStream)fdc.as(InputStream.class)).read();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }
        catch (AssertionFailedError assertionFailedError) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRandomAccessFile() throws Exception {
        File tempFile = AFUNIXSocketAddress.newTempPath((boolean)false);
        try (RandomAccessFile raf = new RandomAccessFile(tempFile, "rw");
             FileChannel fc = (FileChannel)FileDescriptorCast.using((FileDescriptor)raf.getFD()).as(FileChannel.class);){
            ByteBuffer bb = ByteBuffer.allocate(4);
            bb.putInt(305419896);
            bb.flip();
            fc.write(bb);
            Assertions.assertEquals((long)4L, (long)raf.length());
            Assertions.assertEquals((long)4L, (long)raf.getFilePointer());
            raf.seek(2L);
            Assertions.assertEquals((long)2L, (long)fc.position());
            bb.clear();
            Assertions.assertEquals((int)2, (int)fc.read(bb));
            Assertions.assertEquals((int)22136, (int)bb.getShort());
        }
        finally {
            IOUtil.delete((File)tempFile);
        }
    }

    @Test
    public void testPipe() throws Exception {
        try (AFUNIXPipe pipe = AFUNIXPipe.open();
             AFUNIXPipe.SourceChannel source = pipe.source();
             AFUNIXPipe.SinkChannel sink = pipe.sink();){
            ByteBuffer buf = ByteBuffer.allocate(32);
            buf.order(ByteOrder.LITTLE_ENDIAN);
            buf.putInt(61183);
            buf.flip();
            Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(5L), () -> {
                sink.write(buf);
                OutputStream badOut = (OutputStream)FileDescriptorCast.using((FileDescriptor)source.getFileDescriptor()).as(OutputStream.class);
                try {
                    badOut.write(34);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                FileDescriptorCast fdc = FileDescriptorCast.using((FileDescriptor)source.getFileDescriptor());
                InputStream in = (InputStream)fdc.as(InputStream.class);
                Assertions.assertEquals((int)4, (int)in.available());
                Assertions.assertEquals((int)255, (int)in.read());
                Assertions.assertEquals((int)238, (int)in.read());
                Assertions.assertEquals((int)0, (int)in.read());
                Assertions.assertEquals((int)0, (int)in.read());
                OutputStream out = (OutputStream)FileDescriptorCast.using((FileDescriptor)sink.getFileDescriptor()).as(OutputStream.class);
                out.write(34);
                out.write(51);
                buf.clear();
                int numRead = source.read(buf);
                Assertions.assertEquals((int)2, (int)numRead);
                buf.flip();
                Assertions.assertEquals((int)13090, (int)buf.getShort());
            });
        }
    }

    @Test
    @AFUNIXSocketCapabilityRequirement(value={AFUNIXSocketCapability.CAPABILITY_NATIVE_SOCKETPAIR})
    public void testSocketPair() throws Exception {
        AFUNIXSocketPair socketPair = AFUNIXSocketPair.open();
        AFUNIXSocketChannel sock1chan = (AFUNIXSocketChannel)socketPair.getSocket1();
        FileDescriptor sock2fd = ((AFUNIXSocketChannel)socketPair.getSocket2()).getFileDescriptor();
        Assertions.assertTrue((boolean)sock1chan.isConnected());
        FileDescriptorCast fdc = FileDescriptorCast.using((FileDescriptor)sock2fd);
        Assertions.assertEquals((Object)AFUNIXSocket.supports((AFUNIXSocketCapability)AFUNIXSocketCapability.CAPABILITY_NATIVE_SOCKETPAIR), (Object)fdc.isAvailable(Socket.class));
        if (!AFUNIXSocket.supports((AFUNIXSocketCapability)AFUNIXSocketCapability.CAPABILITY_NATIVE_SOCKETPAIR)) {
            FileDescriptorCast.using((FileDescriptor)sock2fd).as(FileChannel.class);
        } else {
            Socket sock2 = (Socket)FileDescriptorCast.using((FileDescriptor)sock2fd).as(Socket.class);
            Assertions.assertEquals(AFUNIXSocket.class, sock2.getClass());
            Assertions.assertTrue((boolean)sock2.isConnected());
            Assertions.assertEquals((Object)sock2fd, (Object)((AFUNIXSocket)sock2).getFileDescriptor());
        }
    }

    @Test
    @AFUNIXSocketCapabilityRequirement(value={AFUNIXSocketCapability.CAPABILITY_NATIVE_SOCKETPAIR})
    public void testSocketPairNative() throws Exception {
        AFUNIXSocketPair socketPair = AFUNIXSocketPair.open();
        AFUNIXSocketChannel sock1chan = (AFUNIXSocketChannel)socketPair.getSocket1();
        FileDescriptor sock2fd = ((AFUNIXSocketChannel)socketPair.getSocket2()).getFileDescriptor();
        Assertions.assertTrue((boolean)sock1chan.isConnected());
        AFUNIXSocketChannel sock2chan = (AFUNIXSocketChannel)FileDescriptorCast.using((FileDescriptor)sock2fd).as(AFUNIXSocketChannel.class);
        Assertions.assertEquals((Object)sock2fd, (Object)sock2chan.getFileDescriptor());
        Assertions.assertTrue((boolean)sock2chan.isConnected());
        ByteBuffer bb = ByteBuffer.allocate(32);
        bb.putInt(305419896);
        bb.flip();
        sock1chan.write(bb);
        bb.clear();
        Assertions.assertEquals((int)4, (int)sock2chan.read(bb));
        bb.flip();
        Assertions.assertEquals((int)305419896, (int)bb.getInt());
    }

    @Test
    public void testUnconnectedServerAsSocket() throws Exception {
        try (AFUNIXServerSocket ass = AFUNIXServerSocket.bindOn((AFUNIXSocketAddress)AFUNIXSocketAddress.ofNewTempFile(), (boolean)true);
             AFUNIXServerSocket ass2 = AFUNIXServerSocket.bindOn((AFUNIXSocketAddress)AFUNIXSocketAddress.ofNewTempFile(), (boolean)true);){
            FileDescriptor fd = ass.getFileDescriptor();
            Assertions.assertTrue((boolean)fd.valid());
            AFUNIXSocket sock = (AFUNIXSocket)FileDescriptorCast.using((FileDescriptor)fd).as(AFUNIXSocket.class);
            Assertions.assertTrue((boolean)sock.isBound());
            Assertions.assertFalse((boolean)sock.isConnected());
            Assertions.assertThrows(SocketException.class, () -> sock.connect((SocketAddress)ass2.getLocalSocketAddress()));
            Assertions.assertThrows(SocketException.class, () -> sock.connect((SocketAddress)ass.getLocalSocketAddress()));
            Assertions.assertThrows(SocketException.class, () -> sock.getInputStream().read());
            Assertions.assertNull((Object)sock.getRemoteSocketAddress());
            Assertions.assertFalse((boolean)sock.isConnected());
        }
    }

    @Test
    public void testServer() throws Exception {
        AFUNIXSocketAddress serverAddress = AFUNIXSocketAddress.ofNewTempFile();
        try (AFUNIXServerSocket ass = AFUNIXServerSocket.bindOn((AFUNIXSocketAddress)serverAddress, (boolean)true);
             AFUNIXSocket sock = AFUNIXSocket.connectTo((AFUNIXSocketAddress)serverAddress);){
            AFUNIXSocket sock1 = (AFUNIXSocket)FileDescriptorCast.using((FileDescriptor)sock.getFileDescriptor()).as(AFUNIXSocket.class);
            Assertions.assertEquals((Object)sock.isBound(), (Object)sock1.isBound());
            Assertions.assertEquals((Object)sock.isConnected(), (Object)sock1.isConnected());
            Assertions.assertTrue((boolean)sock1.isConnected());
            Assertions.assertEquals((Object)sock.getRemoteSocketAddress(), (Object)sock1.getRemoteSocketAddress());
            Assertions.assertEquals((Object)ass.getLocalSocketAddress(), (Object)sock.getRemoteSocketAddress());
            AFUNIXServerSocket serverSock = (AFUNIXServerSocket)FileDescriptorCast.using((FileDescriptor)ass.getFileDescriptor()).as(AFUNIXServerSocket.class);
            AFUNIXSocket sock0 = serverSock.accept();
            Assertions.assertEquals((Object)ass.getLocalSocketAddress(), (Object)sock0.getLocalSocketAddress());
            sock0.getOutputStream().write(23);
            Assertions.assertEquals((int)23, (int)sock1.getInputStream().read());
        }
    }

    @Test
    @AFUNIXSocketCapabilityRequirement(value={AFUNIXSocketCapability.CAPABILITY_DATAGRAMS})
    public void testDatagramSocket() throws Exception {
        AFUNIXSocketAddress addr1 = AFUNIXSocketAddress.ofNewTempFile();
        AFUNIXSocketAddress addr2 = AFUNIXSocketAddress.ofNewTempFile();
        try (AFUNIXDatagramChannel dc1 = AFUNIXDatagramChannel.open();
             AFUNIXDatagramChannel dc2 = AFUNIXDatagramChannel.open();){
            dc1.setDeleteOnClose(true);
            dc2.setDeleteOnClose(true);
            ByteBuffer bb = ByteBuffer.allocate(32);
            bb.putInt(1234);
            bb.flip();
            dc1.getOption(StandardSocketOptions.SO_SNDBUF);
            AFUNIXDatagramChannel dc1c = (AFUNIXDatagramChannel)FileDescriptorCast.using((FileDescriptor)dc1.getFileDescriptor()).as(AFUNIXDatagramChannel.class);
            AFUNIXDatagramChannel dc2c = (AFUNIXDatagramChannel)FileDescriptorCast.using((FileDescriptor)dc2.getFileDescriptor()).as(AFUNIXDatagramChannel.class);
            Assertions.assertFalse((boolean)dc1.isBound());
            Assertions.assertFalse((boolean)dc1c.isBound());
            Assertions.assertFalse((boolean)dc2.isBound());
            Assertions.assertFalse((boolean)dc2c.isBound());
            dc1.bind((SocketAddress)addr1);
            dc2.bind((SocketAddress)addr2);
            Assertions.assertTrue((boolean)dc1.isBound());
            Assertions.assertTrue((boolean)dc1c.isBound());
            Assertions.assertTrue((boolean)dc2.isBound());
            Assertions.assertTrue((boolean)dc2c.isBound());
            Assertions.assertEquals((Object)dc1.getLocalAddress(), (Object)dc1c.getLocalAddress());
            Assertions.assertEquals((Object)dc2.getLocalAddress(), (Object)dc2c.getLocalAddress());
            dc1c.connect((SocketAddress)addr2);
            dc2c.connect((SocketAddress)addr1);
            Assertions.assertTrue((boolean)dc1c.isConnected());
            Assertions.assertTrue((boolean)dc1.isConnected());
            Assertions.assertEquals((Object)dc1.getLocalAddress(), (Object)dc2c.getRemoteAddress());
            Assertions.assertEquals((Object)dc1.getRemoteAddress(), (Object)dc2c.getLocalAddress());
            Assertions.assertEquals((Object)dc1c.getLocalAddress(), (Object)dc2.getRemoteAddress());
            Assertions.assertEquals((Object)dc1c.getRemoteAddress(), (Object)dc2.getLocalAddress());
            Assertions.assertEquals((int)4, (int)dc1c.write(bb));
            bb.clear();
            Assertions.assertEquals((int)4, (int)dc2c.read(bb));
            bb.flip();
            Assertions.assertEquals((int)1234, (int)bb.getInt());
        }
    }

    @Test
    public void testSocketPorts() throws Exception {
        AFUNIXSocketAddress addr = AFUNIXSocketAddress.ofNewTempPath((int)123);
        try (AFUNIXServerSocket ass = AFUNIXServerSocket.bindOn((AFUNIXSocketAddress)addr);){
            Assertions.assertEquals((int)123, (int)ass.getLocalPort());
            AFUNIXServerSocket ass1 = (AFUNIXServerSocket)FileDescriptorCast.using((FileDescriptor)ass.getFileDescriptor()).withLocalPort(123).as(AFUNIXServerSocket.class);
            Assertions.assertEquals((int)123, (int)ass.getLocalPort());
            AFUNIXSocket socket = AFUNIXSocket.connectTo((AFUNIXSocketAddress)addr);
            Assertions.assertEquals((int)123, (int)socket.getRemoteSocketAddress().getPort());
            AFUNIXSocket socket1 = (AFUNIXSocket)FileDescriptorCast.using((FileDescriptor)socket.getFileDescriptor()).withRemotePort(123).as(AFUNIXSocket.class);
            Assertions.assertEquals((Object)socket.getRemoteSocketAddress(), (Object)socket1.getRemoteSocketAddress());
            Assertions.assertEquals((int)123, (int)socket1.getRemoteSocketAddress().getPort());
            AFUNIXSocket ss = ass1.accept();
            Assertions.assertEquals((int)123, (int)ss.getLocalPort());
            Assertions.assertEquals((int)123, (int)ss.getLocalSocketAddress().getPort());
        }
    }

    @Test
    @AFUNIXSocketCapabilityRequirement(value={AFUNIXSocketCapability.CAPABILITY_DATAGRAMS})
    public void testDatagramPorts() throws Exception {
        AFUNIXSocketAddress addr = AFUNIXSocketAddress.ofNewTempPath((int)123);
        Assertions.assertEquals((int)123, (int)addr.getPort());
        try (AFUNIXDatagramChannel dc1 = AFUNIXDatagramChannel.open();
             AFUNIXDatagramChannel dc2 = AFUNIXDatagramChannel.open();){
            dc1.setDeleteOnClose(true);
            dc2.setDeleteOnClose(true);
            Assertions.assertNull((Object)dc1.getLocalAddress());
            Assertions.assertNull((Object)dc1.getRemoteAddress());
            Assertions.assertNull((Object)dc2.getLocalAddress());
            Assertions.assertNull((Object)dc2.getRemoteAddress());
            dc1.bind((SocketAddress)addr);
            dc2.connect((SocketAddress)addr);
            Assertions.assertEquals((Object)dc1.getLocalAddress(), (Object)dc2.getRemoteAddress());
            Assertions.assertEquals((int)123, (int)dc1.getLocalAddress().getPort());
            AFUNIXDatagramChannel dc1c = (AFUNIXDatagramChannel)FileDescriptorCast.using((FileDescriptor)dc1.getFileDescriptor()).as(AFUNIXDatagramChannel.class);
            AFUNIXDatagramChannel dc2c = (AFUNIXDatagramChannel)FileDescriptorCast.using((FileDescriptor)dc2.getFileDescriptor()).as(AFUNIXDatagramChannel.class);
            Assertions.assertEquals((int)0, (int)dc1c.getLocalAddress().getPort());
            Assertions.assertEquals((int)0, (int)dc2c.getRemoteAddress().getPort());
            dc1c = (AFUNIXDatagramChannel)FileDescriptorCast.using((FileDescriptor)dc1.getFileDescriptor()).withLocalPort(123).as(AFUNIXDatagramChannel.class);
            dc2c = (AFUNIXDatagramChannel)FileDescriptorCast.using((FileDescriptor)dc2.getFileDescriptor()).withRemotePort(123).as(AFUNIXDatagramChannel.class);
            Assertions.assertEquals((int)123, (int)dc1c.getLocalAddress().getPort());
            Assertions.assertEquals((int)123, (int)dc2c.getRemoteAddress().getPort());
        }
    }

    @Test
    @AFUNIXSocketCapabilityRequirement(value={AFUNIXSocketCapability.CAPABILITY_DATAGRAMS})
    public void testDatagramFileChannel() throws Exception {
        AFUNIXSocketAddress addr = AFUNIXSocketAddress.ofNewTempPath((int)123);
        try (AFUNIXDatagramChannel dc1 = AFUNIXDatagramChannel.open();
             AFUNIXDatagramChannel dc2 = AFUNIXDatagramChannel.open();){
            dc1.setDeleteOnClose(true);
            dc2.setDeleteOnClose(true);
            dc1.bind((SocketAddress)addr);
            dc2.connect((SocketAddress)addr);
            FileDescriptorCast fdc1 = FileDescriptorCast.using((FileDescriptor)dc1.getFileDescriptor());
            Assertions.assertTrue((boolean)fdc1.isAvailable(DatagramChannel.class));
            Assertions.assertTrue((boolean)fdc1.isAvailable(AFUNIXDatagramChannel.class));
            Assertions.assertTrue((boolean)fdc1.isAvailable(FileChannel.class));
            Assertions.assertTrue((boolean)fdc1.availableTypes().contains(ReadableByteChannel.class));
            Assertions.assertTrue((boolean)fdc1.availableTypes().contains(WritableByteChannel.class));
            FileChannel fc = (FileChannel)fdc1.as(FileChannel.class);
            ByteBuffer bb = ByteBuffer.allocate(4);
            bb.putInt(305419896);
            bb.flip();
            dc2.write(bb);
            bb.clear();
            Assertions.assertEquals((int)4, (int)fc.read(bb));
            bb.flip();
            Assertions.assertEquals((int)305419896, (int)bb.getInt());
        }
    }
}

