/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import java.nio.ByteBuffer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AFUNIXDatagramChannel;
import org.newsclub.net.unix.AFUNIXSocketCapability;
import org.newsclub.net.unix.AFUNIXSocketCapabilityRequirement;
import org.newsclub.net.unix.AFUNIXSocketChannel;
import org.newsclub.net.unix.AFUNIXSocketPair;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class AFUNIXSocketPairTest {
    @Test
    public void testSocketPair() throws Exception {
        AFUNIXSocketPair pair = AFUNIXSocketPair.open();
        AFUNIXSocketChannel sc1 = (AFUNIXSocketChannel)pair.getSocket1();
        AFUNIXSocketChannel sc2 = (AFUNIXSocketChannel)pair.getSocket2();
        Assertions.assertTrue((boolean)sc1.isConnected());
        Assertions.assertTrue((boolean)sc2.isConnected());
        Assertions.assertNotEquals((Object)pair.getSocket1(), (Object)pair.getSocket2());
        Assertions.assertNotEquals((Object)((AFUNIXSocketChannel)pair.getSocket1()).socket(), (Object)((AFUNIXSocketChannel)pair.getSocket2()).socket());
        Assertions.assertEquals((Object)sc1.getPeerCredentials(), (Object)sc2.getPeerCredentials());
        ByteBuffer bb = ByteBuffer.allocate(4096);
        bb.putInt(67305985);
        bb.flip();
        sc1.write(bb);
        ByteBuffer bb2 = ByteBuffer.allocate(4096);
        sc2.read(bb2);
        bb2.flip();
        Assertions.assertEquals((int)67305985, (int)bb2.getInt());
        Assertions.assertNull((Object)((AFUNIXSocketChannel)pair.getSocket1()).getLocalAddress());
        Assertions.assertNull((Object)((AFUNIXSocketChannel)pair.getSocket2()).getLocalAddress());
        Assertions.assertNull((Object)((AFUNIXSocketChannel)pair.getSocket1()).getRemoteAddress());
        Assertions.assertNull((Object)((AFUNIXSocketChannel)pair.getSocket1()).getRemoteAddress());
    }

    @Test
    @AFUNIXSocketCapabilityRequirement(value={AFUNIXSocketCapability.CAPABILITY_DATAGRAMS})
    public void testDatagramPair() throws Exception {
        AFUNIXSocketPair pair = AFUNIXSocketPair.openDatagram();
        AFUNIXDatagramChannel sc1 = (AFUNIXDatagramChannel)pair.getSocket1();
        AFUNIXDatagramChannel sc2 = (AFUNIXDatagramChannel)pair.getSocket2();
        Assertions.assertTrue((boolean)sc1.isConnected());
        Assertions.assertTrue((boolean)sc2.isConnected());
        Assertions.assertNotEquals((Object)pair.getSocket1(), (Object)pair.getSocket2());
        Assertions.assertNotEquals((Object)((AFUNIXDatagramChannel)pair.getSocket1()).socket(), (Object)((AFUNIXDatagramChannel)pair.getSocket2()).socket());
        Assertions.assertEquals((Object)sc1.getPeerCredentials(), (Object)sc2.getPeerCredentials());
        ByteBuffer bb = ByteBuffer.allocate(4096);
        bb.putInt(67305985);
        bb.flip();
        sc1.write(bb);
        ByteBuffer bb2 = ByteBuffer.allocate(4096);
        sc2.read(bb2);
        bb2.flip();
        Assertions.assertEquals((int)67305985, (int)bb2.getInt());
        Assertions.assertNull((Object)((AFUNIXDatagramChannel)pair.getSocket1()).getLocalAddress());
        Assertions.assertNull((Object)((AFUNIXDatagramChannel)pair.getSocket2()).getLocalAddress());
        Assertions.assertNull((Object)((AFUNIXDatagramChannel)pair.getSocket1()).getRemoteAddress());
        Assertions.assertNull((Object)((AFUNIXDatagramChannel)pair.getSocket1()).getRemoteAddress());
    }
}

