/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.rmi;

import java.io.IOException;
import java.rmi.Remote;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AFUNIXSocketCapability;
import org.newsclub.net.unix.AFUNIXSocketCredentials;
import org.newsclub.net.unix.rmi.AFUNIXSocketCapabilityRequirement;
import org.newsclub.net.unix.rmi.RemotePeerInfo;
import org.newsclub.net.unix.rmi.TestBase;
import org.newsclub.net.unix.rmi.TestService;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@AFUNIXSocketCapabilityRequirement(value={AFUNIXSocketCapability.CAPABILITY_PEER_CREDENTIALS})
public class RMIPeerCredentialsTest
extends TestBase {
    @Test
    public void testRemotePeerCredentials() throws Exception {
        TestService svc = this.lookupTestService();
        AFUNIXSocketCredentials clientCreds = svc.remotePeerCredentials();
        AFUNIXSocketCredentials serverCreds = RemotePeerInfo.remotePeerCredentials((Remote)svc);
        if (serverCreds != AFUNIXSocketCredentials.SAME_PROCESS) {
            Assertions.assertEquals((Object)clientCreds, (Object)serverCreds, (String)"Since our tests run in the same process, the peer credentials must be identical");
            Assertions.assertEquals((Object)clientCreds.toString(), (Object)serverCreds.toString(), (String)"Since our tests run in the same process, the peer credentials must be identical");
            Assertions.assertEquals((long)clientCreds.getGid(), (long)serverCreds.getGid(), (String)"Since our tests run in the same process, the peer credentials must be identical");
            Assertions.assertArrayEquals((long[])clientCreds.getGids(), (long[])serverCreds.getGids(), (String)"Since our tests run in the same process, the peer credentials must be identical");
            Assertions.assertEquals((long)clientCreds.getUid(), (long)serverCreds.getUid(), (String)"Since our tests run in the same process, the peer credentials must be identical");
            Assertions.assertEquals((long)clientCreds.getPid(), (long)serverCreds.getPid(), (String)"Since our tests run in the same process, the peer credentials must be identical");
            Assertions.assertEquals((Object)clientCreds.getUUID(), (Object)serverCreds.getUUID(), (String)"Since our tests run in the same process, the peer credentials must be identical");
        }
        Assertions.assertNull((Object)AFUNIXSocketCredentials.remotePeerCredentials(), (String)"AFUNIXSocketCredentials.remotePeerCredentials should be null when called outside of an RMI service");
    }
}

