/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.nio.file.Files;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeEach;
import org.newsclub.net.unix.AFUNIXServerSocket;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketAddress;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class SocketTestBase {
    private static final File SOCKET_FILE = SocketTestBase.initSocketFile();
    private final AFUNIXSocketAddress serverAddress;
    private Exception caller = new Exception();

    protected SocketTestBase() {
        try {
            this.serverAddress = AFUNIXSocketAddress.of((File)SOCKET_FILE);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @BeforeEach
    public void ensureSocketFileIsDeleted() throws IOException {
        Files.deleteIfExists(SOCKET_FILE.toPath());
    }

    @AfterAll
    public static void tearDownClass() throws IOException {
        Files.deleteIfExists(SOCKET_FILE.toPath());
    }

    protected AFUNIXSocketAddress getServerAddress() {
        return this.serverAddress;
    }

    static File newTempFile() {
        return SocketTestBase.newTempFile(null);
    }

    private static File newTempFile(String name) {
        File f;
        try {
            f = name == null ? File.createTempFile("jutest", ".sock") : new File(name);
            f.deleteOnExit();
        }
        catch (IOException e) {
            throw new IllegalStateException("Can't create temporary file", e);
        }
        if (!f.delete()) {
            throw new IllegalStateException("Could not delete temporary file that we just created: " + f);
        }
        return f;
    }

    static File initSocketFile() {
        return SocketTestBase.newTempFile(System.getProperty("org.newsclub.net.unix.testsocket"));
    }

    protected File getSocketFile() {
        return SOCKET_FILE;
    }

    protected AFUNIXServerSocket startServer() throws IOException {
        this.caller = new Exception();
        AFUNIXServerSocket server = AFUNIXServerSocket.newInstance();
        server.bind((SocketAddress)this.serverAddress);
        return server;
    }

    protected AFUNIXSocket connectToServer() throws IOException {
        return AFUNIXSocket.connectTo((AFUNIXSocketAddress)this.serverAddress);
    }

    protected AFUNIXSocket connectToServer(AFUNIXSocket socket) throws IOException {
        socket.connect((SocketAddress)this.serverAddress);
        return socket;
    }

    protected void sleepFor(int ms) throws InterruptedIOException {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw (InterruptedIOException)new InterruptedIOException("sleep interrupted").initCause(e);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    protected abstract class ServerThread
    extends Thread
    implements AutoCloseable {
        private final AFUNIXServerSocket serverSocket;
        private volatile Exception exception = null;
        private volatile Error error = null;
        private final AtomicBoolean loop = new AtomicBoolean(true);
        private final Semaphore sema = new Semaphore(1);

        @SuppressFBWarnings(value={"SC_START_IN_CTOR"})
        protected ServerThread() throws IOException {
            this.serverSocket = this.startServer();
            this.setDaemon(true);
            this.start();
        }

        protected AFUNIXServerSocket startServer() throws IOException {
            return SocketTestBase.this.startServer();
        }

        @Override
        public void close() throws Exception {
            this.shutdown();
            this.checkException();
        }

        public void shutdown() throws IOException {
            this.stopAcceptingConnections();
            if (this.serverSocket != null) {
                this.onServerSocketClose();
                this.serverSocket.close();
            }
        }

        protected abstract void handleConnection(AFUNIXSocket var1) throws IOException;

        protected void stopAcceptingConnections() {
            this.loop.set(false);
        }

        protected void onServerSocketClose() {
            this.stopAcceptingConnections();
        }

        public ServerSocket getServerSocket() {
            return this.serverSocket;
        }

        protected ExceptionHandlingDecision handleException(Exception e) {
            return ExceptionHandlingDecision.RAISE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void acceptAndHandleConnection() throws IOException {
            block16: {
                boolean acceptSuccess = false;
                this.sema.release();
                try (AFUNIXSocket sock = this.serverSocket.accept();){
                    try {
                        this.sema.acquire();
                    }
                    catch (InterruptedException e) {
                        throw (InterruptedIOException)new InterruptedIOException(e.getMessage()).initCause(e);
                    }
                    acceptSuccess = true;
                    this.handleConnection(sock);
                }
                catch (IOException e) {
                    if (!acceptSuccess) {
                        if (this.serverSocket.isClosed()) {
                            this.stopAcceptingConnections();
                        }
                        break block16;
                    }
                    throw e;
                }
                finally {
                    if (acceptSuccess) {
                        this.sema.release();
                    }
                }
            }
        }

        @Override
        public final void run() {
            try {
                this.loop.set(true);
                this.onServerReady();
                while (this.loop.get()) {
                    this.acceptAndHandleConnection();
                }
            }
            catch (Exception e) {
                if (this.loop.get() && this.handleException(e) != ExceptionHandlingDecision.IGNORE) {
                    e.addSuppressed(SocketTestBase.this.caller);
                    this.exception = e;
                }
            }
            catch (Error e) {
                this.error = e;
            }
        }

        protected void onServerReady() {
        }

        public void checkException() throws Exception {
            boolean serverStillRunning;
            boolean bl = serverStillRunning = !this.sema.tryAcquire(30L, TimeUnit.SECONDS);
            if (this.error != null) {
                throw this.error;
            }
            if (this.exception != null) {
                throw this.exception;
            }
            if (serverStillRunning) {
                throw new IllegalStateException("SocketTestBase server still running after 30 seconds");
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    protected static enum ExceptionHandlingDecision {
        RAISE,
        IGNORE;

    }
}

