/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import java.io.File;
import java.io.IOException;
import java.net.SocketAddress;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AFUNIXSelectorProvider;
import org.newsclub.net.unix.AFUNIXServerSocketChannel;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.AFUNIXSocketChannel;
import org.newsclub.net.unix.SocketTestBase;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class AFUNIXSocketChannelTest {
    private final AFUNIXSelectorProvider provider = AFUNIXSelectorProvider.provider();

    @Test
    public void testNonBlockingConnect() throws IOException {
        AFUNIXSocketAddress sa = AFUNIXSocketAddress.of((File)SocketTestBase.newTempFile());
        AFUNIXServerSocketChannel ssc = this.provider.openServerSocketChannel();
        ssc.configureBlocking(false);
        ssc.bind((SocketAddress)sa, 1);
        AFUNIXSocketChannel sc = this.provider.openSocketChannel();
        sc.configureBlocking(false);
        if (!sc.connect((SocketAddress)sa)) {
            Assertions.assertTrue((sc.isConnected() || sc.isConnectionPending() ? 1 : 0) != 0);
            long now = System.currentTimeMillis();
            while (!sc.finishConnect()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    break;
                }
                if (System.currentTimeMillis() - now > 1000L) {
                    Assertions.fail((String)"Non-blocking connect not connected after 1s");
                    break;
                }
                if (!Thread.interrupted()) continue;
            }
            Assertions.assertTrue((boolean)sc.finishConnect());
        }
        Assertions.assertTrue((boolean)sc.isConnected());
        Assertions.assertFalse((boolean)sc.isConnectionPending());
    }
}

