/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.file.Files;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AFUNIXServerSocket;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.SocketTestBase;
import org.newsclub.net.unix.SuppressFBWarnings;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@SuppressFBWarnings(value={"RANGE_ARRAY_LENGTH"})
public class BufferOverflowTest {
    private File socketFile;
    private ServerSocket server;
    private ExecutorService executor;

    @BeforeEach
    public void setUp() throws IOException {
        this.socketFile = SocketTestBase.initSocketFile();
        this.server = AFUNIXServerSocket.newInstance();
        this.server.bind((SocketAddress)new AFUNIXSocketAddress(this.socketFile));
        this.executor = Executors.newFixedThreadPool(2);
    }

    @AfterEach
    public void tearDown() throws IOException {
        try {
            if (this.server != null) {
                this.server.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.socketFile != null) {
            Files.delete(this.socketFile.toPath());
        }
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }

    Socket[] connectToServer() throws Exception {
        AFUNIXSocket clientSocket = AFUNIXSocket.newInstance();
        Future<Socket> serverAcceptFuture = this.executor.submit(new Callable<Socket>(){

            @Override
            public Socket call() throws Exception {
                return BufferOverflowTest.this.server.accept();
            }
        });
        Thread.sleep(100L);
        clientSocket.connect((SocketAddress)new AFUNIXSocketAddress(this.socketFile));
        Socket serverSocket = serverAcceptFuture.get(100L, TimeUnit.MILLISECONDS);
        return new Socket[]{serverSocket, clientSocket};
    }

    @Test
    public void readOutOfBounds() throws Exception {
        Assertions.assertTimeout((Duration)Duration.ofSeconds(2L), () -> {
            Socket[] sockets = this.connectToServer();
            try (Socket serverSocket = sockets[0];
                 Socket clientSocket = sockets[1];){
                byte[] input = new byte[16];
                byte[] output = new byte[15];
                try (OutputStream clientOutStream = clientSocket.getOutputStream();
                     InputStream serverInStream = serverSocket.getInputStream();){
                    clientOutStream.write(input, 0, 16);
                    int numRead = serverInStream.read(output, 0, 16);
                    Assertions.fail((String)("The call to read should have thrown an IndexOutOfBoundsException, read: " + numRead + " bytes"));
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        });
    }

    @Test
    public void readUpTo() throws Exception {
        Assertions.assertTimeout((Duration)Duration.ofSeconds(2L), () -> {
            Socket[] sockets = this.connectToServer();
            try (Socket serverSocket = sockets[0];
                 Socket clientSocket = sockets[1];){
                byte[] input = new byte[16];
                byte[] output = new byte[256];
                try (OutputStream clientOutStream = clientSocket.getOutputStream();
                     InputStream serverInStream = serverSocket.getInputStream();){
                    clientOutStream.write(input, 0, 16);
                    int numRead = serverInStream.read(output, 0, 256);
                    Assertions.assertEquals((int)16, (int)numRead, (String)"Number of bytes read mismatch");
                }
            }
        });
    }

    @Test
    public void writeOverflow() throws Exception {
        Assertions.assertTimeout((Duration)Duration.ofSeconds(2L), () -> {
            Socket[] sockets = this.connectToServer();
            try (Socket serverSocket = sockets[0];
                 Socket clientSocket = sockets[1];){
                byte[] input = new byte[15];
                byte[] output = new byte[16];
                try (OutputStream clientOutStream = clientSocket.getOutputStream();
                     InputStream serverInStream = serverSocket.getInputStream();){
                    try {
                        clientOutStream.write(input, 0, 16);
                        int numRead = serverInStream.read(output, 0, 15);
                        Assertions.assertEquals((int)15, (int)numRead);
                        serverInStream.read();
                        Assertions.fail((String)"The call to read should have thrown an IndexOutOfBoundsException");
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            }
        });
    }
}

