/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.SocketException;
import java.nio.file.Files;
import java.time.Duration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketCapability;
import org.newsclub.net.unix.AFUNIXSocketCapabilityRequirement;
import org.newsclub.net.unix.SocketTestBase;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@AFUNIXSocketCapabilityRequirement(value={AFUNIXSocketCapability.CAPABILITY_FILE_DESCRIPTORS})
public class FileDescriptorsTest
extends SocketTestBase {
    @Test
    public void testSendRecvFileDescriptors() throws Exception {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(2L), () -> {
            SocketTestBase.ServerThread serverThread = new SocketTestBase.ServerThread(){

                @Override
                protected void handleConnection(Socket sock) throws IOException {
                    AFUNIXSocket socket = (AFUNIXSocket)sock;
                    socket.setOutboundFileDescriptors(new FileDescriptor[]{FileDescriptor.out, FileDescriptor.err});
                    socket.getOutputStream().write("HELLO".getBytes("UTF-8"));
                    this.stopAcceptingConnections();
                }
            };
            try (AFUNIXSocket socket = this.connectToServer();
                 InputStream in = socket.getInputStream();){
                socket.setAncillaryReceiveBufferSize(1024);
                byte[] buf = new byte[64];
                FileDescriptor[] fds = socket.getReceivedFileDescriptors();
                Assertions.assertNull((Object)fds, (String)"Initially, there are no file descriptors");
                int numRead = in.read(buf);
                Assertions.assertEquals((int)5, (int)numRead, (String)"'HELLO' is five bytes long");
                Assertions.assertEquals((Object)"HELLO", (Object)new String(buf, 0, numRead, "UTF-8"));
                fds = socket.getReceivedFileDescriptors();
                Assertions.assertEquals((int)2, (int)fds.length, (String)"Now, we should have two file descriptors");
                fds = socket.getReceivedFileDescriptors();
                Assertions.assertNull((Object)fds, (String)"If we ask again, these new file descriptors should be gone");
                numRead = socket.getInputStream().read(buf);
                Assertions.assertEquals((int)-1, (int)numRead, (String)"There shouldn't be anything left to read");
                fds = socket.getReceivedFileDescriptors();
                Assertions.assertNull((Object)fds, (String)"There shouldn't be any new file descriptors");
            }
            serverThread.getServerSocket().close();
            serverThread.checkException();
        });
    }

    @Test
    public void testBadFileDescriptor() throws Exception {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(2L), () -> {
            SocketTestBase.ServerThread serverThread = new SocketTestBase.ServerThread(){

                @Override
                protected void handleConnection(Socket sock) throws IOException {
                    AFUNIXSocket socket = (AFUNIXSocket)sock;
                    socket.setOutboundFileDescriptors(new FileDescriptor[]{new FileDescriptor()});
                    try {
                        socket.getOutputStream().write(123);
                        Assertions.fail((String)"Expected a \"Bad file descriptor\" SocketException");
                    }
                    catch (SocketException socketException) {
                        // empty catch block
                    }
                    this.stopAcceptingConnections();
                }
            };
            try (AFUNIXSocket socket = this.connectToServer();){
                socket.setAncillaryReceiveBufferSize(1024);
                socket.getInputStream().read();
            }
            serverThread.getServerSocket().close();
            serverThread.checkException();
        });
    }

    @Test
    public void testNoAncillaryReceiveBuffer() throws Exception {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(2L), () -> {
            SocketTestBase.ServerThread serverThread = new SocketTestBase.ServerThread(){

                @Override
                protected void handleConnection(Socket sock) throws IOException {
                    AFUNIXSocket socket = (AFUNIXSocket)sock;
                    socket.setOutboundFileDescriptors(new FileDescriptor[]{FileDescriptor.out, FileDescriptor.err});
                    socket.getOutputStream().write(123);
                    this.stopAcceptingConnections();
                }
            };
            try (AFUNIXSocket socket = this.connectToServer();){
                try {
                    Assertions.assertEquals((int)123, (int)socket.getInputStream().read());
                }
                catch (SocketException socketException) {
                    // empty catch block
                }
                Assertions.assertNull((Object)socket.getReceivedFileDescriptors());
                Assertions.assertEquals((int)0, (int)socket.getAncillaryReceiveBufferSize());
            }
            serverThread.getServerSocket().close();
            serverThread.checkException();
        });
    }

    @Test
    public void testAncillaryReceiveBufferTooSmall() throws Exception {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(2L), () -> {
            SocketTestBase.ServerThread serverThread = new SocketTestBase.ServerThread(){

                @Override
                protected void handleConnection(Socket sock) throws IOException {
                    AFUNIXSocket socket = (AFUNIXSocket)sock;
                    socket.setOutboundFileDescriptors(new FileDescriptor[]{FileDescriptor.out, FileDescriptor.err});
                    socket.getOutputStream().write(123);
                    this.stopAcceptingConnections();
                }
            };
            try (AFUNIXSocket socket = this.connectToServer();){
                socket.setAncillaryReceiveBufferSize(13);
                try {
                    Assertions.assertEquals((int)123, (int)socket.getInputStream().read());
                    Assertions.fail((String)"Expected a \"No buffer space available\" SocketException");
                }
                catch (SocketException socketException) {
                    // empty catch block
                }
                Assertions.assertNull((Object)socket.getReceivedFileDescriptors());
            }
            serverThread.getServerSocket().close();
            serverThread.checkException();
        });
    }

    @Test
    public void testFileInputStream() throws Exception {
        final File tmpFile = File.createTempFile("junixsocket", "test");
        tmpFile.deleteOnExit();
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(2L), () -> {
            SocketTestBase.ServerThread serverThread = new SocketTestBase.ServerThread(){

                @Override
                protected void handleConnection(Socket sock) throws IOException {
                    AFUNIXSocket socket = (AFUNIXSocket)sock;
                    try (FileOutputStream fos = new FileOutputStream(tmpFile);){
                        fos.write("WORLD!".getBytes("UTF-8"));
                    }
                    try (FileInputStream fin = new FileInputStream(tmpFile);){
                        socket.setOutboundFileDescriptors(new FileDescriptor[]{fin.getFD()});
                        socket.getOutputStream().write("HELLO".getBytes("UTF-8"));
                    }
                    this.stopAcceptingConnections();
                }
            };
            try (AFUNIXSocket socket = this.connectToServer();
                 InputStream in = socket.getInputStream();){
                socket.setAncillaryReceiveBufferSize(1024);
                byte[] buf = new byte[64];
                int numRead = in.read(buf);
                Assertions.assertEquals((int)5, (int)numRead, (String)"'HELLO' is five bytes long");
                Assertions.assertEquals((Object)"HELLO", (Object)new String(buf, 0, numRead, "UTF-8"));
                FileDescriptor[] fds = socket.getReceivedFileDescriptors();
                Assertions.assertEquals((int)1, (int)fds.length, (String)"Now, we should have two file descriptors");
                FileDescriptor fdesc = fds[0];
                try (FileInputStream fin = new FileInputStream(fdesc);){
                    numRead = fin.read(buf);
                    Assertions.assertEquals((int)6, (int)numRead, (String)"'WORLD!' is six bytes long");
                    Assertions.assertEquals((Object)"WORLD!", (Object)new String(buf, 0, numRead, "UTF-8"));
                }
            }
            serverThread.getServerSocket().close();
            serverThread.checkException();
            Files.delete(tmpFile.toPath());
        });
    }

    @Test
    public void testFileInputStreamPartiallyConsumed() throws Exception {
        final File tmpFile = File.createTempFile("junixsocket", "test");
        tmpFile.deleteOnExit();
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(2L), () -> {
            SocketTestBase.ServerThread serverThread = new SocketTestBase.ServerThread(){

                @Override
                protected void handleConnection(Socket sock) throws IOException {
                    AFUNIXSocket socket = (AFUNIXSocket)sock;
                    try (FileOutputStream fos = new FileOutputStream(tmpFile);){
                        fos.write("WORLD!".getBytes("UTF-8"));
                    }
                    try (FileInputStream fin = new FileInputStream(tmpFile);){
                        Assertions.assertEquals((int)87, (int)fin.read());
                        socket.setOutboundFileDescriptors(new FileDescriptor[]{fin.getFD()});
                        socket.getOutputStream().write("HELLO".getBytes("UTF-8"));
                    }
                    this.stopAcceptingConnections();
                }
            };
            try (AFUNIXSocket socket = this.connectToServer();
                 InputStream in = socket.getInputStream();){
                socket.setAncillaryReceiveBufferSize(1024);
                byte[] buf = new byte[64];
                int numRead = in.read(buf);
                Assertions.assertEquals((int)5, (int)numRead, (String)"'HELLO' is five bytes long");
                Assertions.assertEquals((Object)"HELLO", (Object)new String(buf, 0, numRead, "UTF-8"));
                FileDescriptor[] fds = socket.getReceivedFileDescriptors();
                Assertions.assertEquals((int)1, (int)fds.length, (String)"Now, we should have two file descriptors");
                FileDescriptor fdesc = fds[0];
                try (FileInputStream fin = new FileInputStream(fdesc);){
                    numRead = fin.read(buf);
                    Assertions.assertEquals((int)5, (int)numRead, (String)"'ORLD!' is five bytes long");
                    Assertions.assertEquals((Object)"ORLD!", (Object)new String(buf, 0, numRead, "UTF-8"));
                }
            }
            serverThread.getServerSocket().close();
            serverThread.checkException();
            Files.delete(tmpFile.toPath());
        });
    }
}

