/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import com.kohlschutter.testutil.TestAbortedNotAnIssueException;
import com.kohlschutter.util.SystemPropertyUtil;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.newsclub.net.unix.AddressSpecifics;
import org.newsclub.net.unix.SocketTestBase;
import org.newsclub.net.unix.ThreadUtil;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public abstract class InterruptIssue158Test<A extends SocketAddress>
extends SocketTestBase<A> {
    private static boolean DEBUG = SystemPropertyUtil.getBooleanSystemProperty((String)"selftest.issue.158.debug", (boolean)false);
    private static boolean DEBUG_VERBOSE = System.getProperty("com.kohlschutter.selftest") == null && SystemPropertyUtil.getBooleanSystemProperty((String)"selftest.issue.158.debug.verbose", (boolean)true);
    private static boolean DELAY_CLOSE = SystemPropertyUtil.getBooleanSystemProperty((String)"selftest.issue.158.delay-close", (boolean)true);
    private A address = this.newAddress();
    private TestInfo testInfo;
    private List<AutoCloseable> closeables = new ArrayList<AutoCloseable>();

    protected InterruptIssue158Test(AddressSpecifics<A> asp) {
        super(asp);
    }

    @BeforeEach
    public void beforeEach(TestInfo info) {
        this.testInfo = info;
        this.address = this.newAddress();
    }

    private A newAddress() {
        try {
            return (A)this.newTempAddress();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void closeAfterTest() {
        this.deleteSocketFile(this.address);
        for (AutoCloseable cl : this.closeables) {
            try {
                cl.close();
            }
            catch (Exception exception) {}
        }
        this.closeables.clear();
    }

    @AfterEach
    public void afterEach() {
        this.closeAfterTest();
    }

    protected abstract void deleteSocketFile(A var1);

    public List<Arguments> clientProvider() {
        return Arrays.asList(InterruptIssue158Test.socket(false, this::newSocket, s -> s.connect((SocketAddress)this.address), SocketException.class, Socket::isClosed), InterruptIssue158Test.socket(true, () -> this.newConnectedSocket((SocketAddress)this.address), s -> s.getInputStream().read(), SocketException.class, Socket::isClosed), InterruptIssue158Test.socket(true, () -> this.newConnectedSocket((SocketAddress)this.address), s -> s.getOutputStream().write(10), SocketException.class, Socket::isClosed), InterruptIssue158Test.socket(false, this::newSocketChannel, s -> s.connect((SocketAddress)this.address), ClosedByInterruptException.class, s -> !s.isOpen()), InterruptIssue158Test.socket(true, this::connectSocketChannel, s -> s.read(ByteBuffer.allocate(1)), ClosedByInterruptException.class, s -> !s.isOpen()), InterruptIssue158Test.socket(true, this::connectSocketChannel, s -> s.write(ByteBuffer.allocate(1)), ClosedByInterruptException.class, s -> !s.isOpen()));
    }

    public List<Arguments> serverProvider() {
        return Arrays.asList(InterruptIssue158Test.serverSocket(() -> this.registerCloseable(this.newServerSocketBindOn((SocketAddress)this.address)), ServerSocket::accept, SocketException.class, ServerSocket::isClosed), InterruptIssue158Test.serverSocket(this::bindServerSocketChannel, ServerSocketChannel::accept, ClosedByInterruptException.class, s -> !s.isOpen()));
    }

    @ParameterizedTest(name="variant {index}")
    @MethodSource(value={"clientProvider"})
    public <T extends AutoCloseable> void testClientInterruption(boolean acceptConnections, IOSupplier<T> socket, IOConsumer<T> blockingOp, Class<?> expectedException, Predicate<T> closeCheck) throws Throwable {
        this.withServer(acceptConnections, () -> this.testSocketInterruption(false, socket, blockingOp, expectedException, closeCheck));
    }

    @ParameterizedTest(name="variant {index}")
    @MethodSource(value={"clientProvider"})
    public <T extends AutoCloseable> void testClientInterruptionWithDelay(boolean acceptConnections, IOSupplier<T> socket, IOConsumer<T> blockingOp, Class<?> expectedException, Predicate<T> closeCheck) throws Throwable {
        this.withServer(acceptConnections, () -> this.testSocketInterruption(true, socket, blockingOp, expectedException, closeCheck));
    }

    @ParameterizedTest(name="variant {index}")
    @MethodSource(value={"serverProvider"})
    public <T extends AutoCloseable> void testServerInterruption(IOSupplier<T> socket, IOConsumer<T> blockingOp, Class<?> expectedException, Predicate<T> closeCheck) throws Throwable {
        this.testSocketInterruption(false, socket, blockingOp, expectedException, closeCheck);
    }

    @ParameterizedTest(name="variant {index}")
    @MethodSource(value={"serverProvider"})
    public <T extends AutoCloseable> void testServerInterruptionWithDelay(IOSupplier<T> socket, IOConsumer<T> blockingOp, Class<?> expectedException, Predicate<T> closeCheck) throws Throwable {
        this.testSocketInterruption(true, socket, blockingOp, expectedException, closeCheck);
    }

    public <T extends AutoCloseable> void testSocketInterruption(boolean delay, IOSupplier<T> socket, IOConsumer<T> blockingOp, Class<?> expectedException, Predicate<T> closeCheck) throws Throwable {
        Throwable thrownException;
        AtomicReference exceptionHolder = new AtomicReference();
        CountDownLatch ready = new CountDownLatch(1);
        Thread t = ThreadUtil.startNewDaemonThread((boolean)true, () -> exceptionHolder.set(this.runOperation(ready, socket, blockingOp, expectedException, closeCheck)));
        ready.await();
        if (delay) {
            Thread.sleep(500L);
        }
        t.interrupt();
        t.join(Duration.of(1L, ChronoUnit.SECONDS).toMillis());
        if (t.isAlive()) {
            this.closeAfterTest();
            t.interrupt();
            t.join(Duration.of(1L, ChronoUnit.SECONDS).toMillis());
            if (t.isAlive()) {
                throw new RuntimeException("Thread failed to terminate after interrupt");
            }
        }
        if ((thrownException = (Throwable)exceptionHolder.get()) != null) {
            throw thrownException;
        }
    }

    private <C extends AutoCloseable> C registerCloseable(C closeable) {
        this.closeables.add(closeable);
        return closeable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void withServer(boolean acceptConnections, ThrowingRunnable func) throws Throwable {
        Semaphore done = new Semaphore(0);
        try (ServerSocketChannel serverSocket = this.registerCloseable(this.newServerSocketChannel());){
            serverSocket.bind((SocketAddress)this.address);
            Thread serverThread = null;
            if (acceptConnections) {
                serverThread = ThreadUtil.startNewDaemonThread((boolean)false, () -> {
                    while (serverSocket.isOpen()) {
                        SocketChannel socket = null;
                        try {
                            socket = serverSocket.accept();
                        }
                        catch (ClosedChannelException e) {
                            return;
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Unable to accept socket ", e);
                        }
                        finally {
                            if (socket == null) continue;
                            SocketChannel socketToClose = socket;
                            if (DELAY_CLOSE) {
                                CompletableFuture.runAsync(() -> {
                                    try {
                                        if (done.tryAcquire(1L, TimeUnit.SECONDS)) {
                                            // empty if block
                                        }
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                    try {
                                        socketToClose.close();
                                        return;
                                    }
                                    catch (IOException e) {
                                        e.printStackTrace();
                                    }
                                });
                                continue;
                            }
                            try {
                                socketToClose.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                });
            }
            try {
                func.run();
            }
            finally {
                done.release();
                serverSocket.close();
                if (serverThread != null) {
                    serverThread.join();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    <T extends AutoCloseable> Throwable runOperation(CountDownLatch ready, IOSupplier<T> socket, IOConsumer<T> blockingOp, Class<?> expectedException, Predicate<T> closeCheck) {
        boolean supported = false;
        Exception exc = null;
        try {
            AutoCloseable sock = this.registerCloseable((AutoCloseable)socket.get());
            ready.countDown();
            supported = true;
            try {
                blockingOp.accept(sock);
            }
            catch (Exception e) {
                boolean interruptStateOK;
                exc = e;
                boolean ignoreInterruptState = SocketException.class.equals(expectedException);
                boolean bl = interruptStateOK = Thread.interrupted() || ClosedChannelException.class.isAssignableFrom(expectedException) && !(e instanceof ClosedByInterruptException);
                if (!expectedException.isAssignableFrom(e.getClass())) {
                    e.printStackTrace();
                }
                Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertInstanceOf((Class)expectedException, (Object)e, (String)"Socket exception"), () -> Assertions.assertTrue((ignoreInterruptState || interruptStateOK ? 1 : 0) != 0, (String)"Thread interrupted"), () -> Assertions.assertTrue((boolean)closeCheck.test(sock), (String)"Socket closed")});
            }
            finally {
                ready.countDown();
                if (sock != null) {
                    try {
                        sock.close();
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Unable to clean up socket", e);
                    }
                }
            }
            ready.countDown();
            if (DEBUG) {
                if (DEBUG_VERBOSE) {
                    System.out.print(((Class)this.testInfo.getTestClass().get()).getName() + "." + ((Method)this.testInfo.getTestMethod().get()).getName() + " " + this.testInfo.getDisplayName() + ": ");
                }
                System.out.println(supported ? (exc == null ? "no exception" : exc) : "unsupported");
            }
        }
        catch (TestAbortedNotAnIssueException e) {
            TestAbortedNotAnIssueException testAbortedNotAnIssueException = e;
            ready.countDown();
            if (DEBUG) {
                if (DEBUG_VERBOSE) {
                    System.out.print(((Class)this.testInfo.getTestClass().get()).getName() + "." + ((Method)this.testInfo.getTestMethod().get()).getName() + " " + this.testInfo.getDisplayName() + ": ");
                }
                System.out.println(supported ? (exc == null ? "no exception" : exc) : "unsupported");
            }
            return testAbortedNotAnIssueException;
        }
        catch (Throwable e2) {
            e2.printStackTrace();
            Throwable throwable = e2;
            ready.countDown();
            if (DEBUG) {
                if (DEBUG_VERBOSE) {
                    System.out.print(((Class)this.testInfo.getTestClass().get()).getName() + "." + ((Method)this.testInfo.getTestMethod().get()).getName() + " " + this.testInfo.getDisplayName() + ": ");
                }
                System.out.println(supported ? (exc == null ? "no exception" : exc) : "unsupported");
            }
            return throwable;
            {
                catch (Throwable throwable2) {
                    ready.countDown();
                    if (DEBUG) {
                        if (DEBUG_VERBOSE) {
                            System.out.print(((Class)this.testInfo.getTestClass().get()).getName() + "." + ((Method)this.testInfo.getTestMethod().get()).getName() + " " + this.testInfo.getDisplayName() + ": ");
                        }
                        System.out.println(supported ? (exc == null ? "no exception" : exc) : "unsupported");
                    }
                    throw throwable2;
                }
            }
        }
        return null;
    }

    private static <T> Arguments socket(boolean acceptConnections, IOSupplier<T> socket, IOConsumer<T> blockingOp, Class<?> expectedException, Predicate<T> closeCheck) {
        return Arguments.of((Object[])new Object[]{acceptConnections, socket, blockingOp, expectedException, closeCheck});
    }

    private static <T> Arguments serverSocket(IOSupplier<T> socket, IOConsumer<T> blockingOp, Class<?> expectedException, Predicate<T> closeCheck) {
        return Arguments.of((Object[])new Object[]{socket, blockingOp, expectedException, closeCheck});
    }

    private SocketChannel connectSocketChannel() throws IOException {
        SocketChannel socket = this.registerCloseable(this.newSocketChannel());
        socket.connect((SocketAddress)this.address);
        return socket;
    }

    private ServerSocketChannel bindServerSocketChannel() throws IOException {
        ServerSocketChannel socket = this.registerCloseable(this.newServerSocketChannel());
        try {
            try {
                socket.bind((SocketAddress)this.address);
            }
            catch (BindException e) {
                this.address = this.newAddress();
                socket.bind((SocketAddress)this.address);
            }
        }
        catch (BindException e) {
            throw (BindException)new BindException(e.getMessage() + ": " + this.address).initCause(e);
        }
        return socket;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static interface IOSupplier<T> {
        public T get() throws IOException;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static interface IOConsumer<T> {
        public void accept(T var1) throws IOException;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static interface ThrowingRunnable {
        public void run() throws Throwable;
    }
}

