/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import com.kohlschutter.testutil.TestAbortedNotAnIssueException;
import com.kohlschutter.util.IOUtil;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.eclipse.jdt.annotation.Nullable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AFGenericServerSocketChannel;
import org.newsclub.net.unix.AFGenericSocket;
import org.newsclub.net.unix.AFGenericSocketAddress;
import org.newsclub.net.unix.AFGenericSocketChannel;
import org.newsclub.net.unix.AFPipe;
import org.newsclub.net.unix.AFSocketCapability;
import org.newsclub.net.unix.AFSocketCapabilityRequirement;
import org.newsclub.net.unix.AFUNIXServerSocketChannel;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.BrokenPipeSocketException;
import org.newsclub.net.unix.FileDescriptorCast;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@SuppressFBWarnings(value={"THROWS_METHOD_THROWS_CLAUSE_THROWABLE", "THROWS_METHOD_THROWS_CLAUSE_BASIC_EXCEPTION"})
public class FileDescriptorCastTest {
    @Test
    public void testInvalidFileDescriptor() throws IOException {
        Assertions.assertThrows(IOException.class, () -> FileDescriptorCast.using((FileDescriptor)new FileDescriptor()));
        Assertions.assertThrows(NullPointerException.class, () -> FileDescriptorCast.using(null));
        Assertions.assertThrows(ClassCastException.class, () -> FileDescriptorCast.using((FileDescriptor)FileDescriptor.out).as(Runtime.class));
    }

    @Test
    public void testAvailableTypes() throws IOException {
        FileDescriptorCast fdc = FileDescriptorCast.using((FileDescriptor)FileDescriptor.out);
        Set availableTypes = fdc.availableTypes();
        Assertions.assertTrue((boolean)availableTypes.contains(OutputStream.class));
        Assertions.assertTrue((boolean)fdc.isAvailable(OutputStream.class));
        Assertions.assertFalse((boolean)fdc.isAvailable(System.class));
    }

    @Test
    public void testStdout() throws IOException {
        FileDescriptorCast fdc = FileDescriptorCast.using((FileDescriptor)FileDescriptor.out);
        Assertions.assertThrows(ClassCastException.class, () -> fdc.as(Socket.class));
        Assertions.assertThrows(ClassCastException.class, () -> fdc.as(AFUNIXSocket.class));
        Assertions.assertThrows(NullPointerException.class, () -> fdc.as(null));
        Assertions.assertEquals((Object)fdc.getFileDescriptor(), (Object)fdc.as(Object.class));
        Assertions.assertEquals((Object)fdc.getFileDescriptor(), (Object)fdc.as(FileDescriptor.class));
        Assertions.assertEquals(((OutputStream)fdc.as(OutputStream.class)).getClass(), ((FileOutputStream)fdc.as(FileOutputStream.class)).getClass());
        Assertions.assertEquals(((InputStream)fdc.as(InputStream.class)).getClass(), ((FileInputStream)fdc.as(FileInputStream.class)).getClass());
    }

    @Test
    public void testCastAsInteger() throws Exception {
        Assertions.assertNotEquals((int)-1, (Integer)((Integer)FileDescriptorCast.using((FileDescriptor)FileDescriptor.in).as(Integer.class)));
        Assertions.assertNotEquals((int)-1, (Integer)((Integer)FileDescriptorCast.using((FileDescriptor)FileDescriptor.out).as(Integer.class)));
        Assertions.assertNotEquals((int)-1, (Integer)((Integer)FileDescriptorCast.using((FileDescriptor)FileDescriptor.err).as(Integer.class)));
        Assertions.assertThrows(IOException.class, () -> FileDescriptorCast.using((FileDescriptor)new FileDescriptor()).as(Integer.class));
    }

    @Test
    @AFSocketCapabilityRequirement(value={AFSocketCapability.CAPABILITY_UNSAFE})
    public void testUnsafeCast() throws Exception {
        Assertions.assertEquals((int)1, (Integer)((Integer)FileDescriptorCast.unsafeUsing((int)1).as(Integer.class)));
        Assertions.assertEquals((int)-2, (Integer)((Integer)FileDescriptorCast.unsafeUsing((int)-2).as(Integer.class)));
        Assertions.assertSame((Object)FileDescriptor.out, (Object)FileDescriptorCast.unsafeUsing((int)((Integer)FileDescriptorCast.using((FileDescriptor)FileDescriptor.out).as(Integer.class))).as(FileDescriptor.class));
        Assertions.assertThrows(IOException.class, () -> FileDescriptorCast.unsafeUsing((int)-1).as(Integer.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRandomAccessFile() throws Exception {
        File tempFile = AFUNIXSocketAddress.newTempPath((boolean)false);
        try (RandomAccessFile raf = new RandomAccessFile(tempFile, "rw");
             FileChannel fc = (FileChannel)FileDescriptorCast.using((FileDescriptor)raf.getFD()).as(FileChannel.class);){
            ByteBuffer bb = ByteBuffer.allocate(4);
            bb.putInt(305419896);
            bb.flip();
            fc.write(bb);
            Assertions.assertEquals((long)4L, (long)raf.length());
            Assertions.assertEquals((long)4L, (long)raf.getFilePointer());
            raf.seek(2L);
            Assertions.assertEquals((long)2L, (long)fc.position());
            bb.clear();
            Assertions.assertEquals((int)2, (int)fc.read(bb));
            Assertions.assertEquals((int)22136, (int)bb.getShort());
        }
        finally {
            IOUtil.delete((File)tempFile);
        }
    }

    @Test
    public void testPipe() throws Exception {
        try (AFPipe pipe = AFPipe.open();
             AFPipe.SourceChannel source = pipe.source();
             AFPipe.SinkChannel sink = pipe.sink();){
            ByteBuffer buf = ByteBuffer.allocate(32);
            buf.order(ByteOrder.LITTLE_ENDIAN);
            buf.putInt(61183);
            buf.flip();
            Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(5L), () -> {
                sink.write(buf);
                OutputStream badOut = (OutputStream)FileDescriptorCast.using((FileDescriptor)source.getFileDescriptor()).as(OutputStream.class);
                try {
                    badOut.write(34);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                FileDescriptorCast fdc = FileDescriptorCast.using((FileDescriptor)source.getFileDescriptor());
                InputStream in = (InputStream)fdc.as(InputStream.class);
                int available = in.available();
                if (available != 0) {
                    Assertions.assertEquals((int)4, (int)available);
                }
                Assertions.assertEquals((int)255, (int)in.read());
                Assertions.assertEquals((int)238, (int)in.read());
                Assertions.assertEquals((int)0, (int)in.read());
                Assertions.assertEquals((int)0, (int)in.read());
                OutputStream out = (OutputStream)FileDescriptorCast.using((FileDescriptor)sink.getFileDescriptor()).as(OutputStream.class);
                out.write(34);
                out.write(51);
                buf.clear();
                int numRead = source.read(buf);
                Assertions.assertEquals((int)2, (int)numRead);
                buf.flip();
                Assertions.assertEquals((int)13090, (int)buf.getShort());
            });
        }
    }

    @AFSocketCapabilityRequirement(value={AFSocketCapability.CAPABILITY_UNIX_DOMAIN})
    @Test
    public void testCastGeneric() throws Exception {
        try (AFUNIXServerSocketChannel ussc = AFUNIXServerSocketChannel.open();){
            ussc.bind((SocketAddress)AFUNIXSocketAddress.ofNewTempFile());
            AFGenericServerSocketChannel gssc = (AFGenericServerSocketChannel)FileDescriptorCast.using((FileDescriptor)ussc.getFileDescriptor()).as(AFGenericServerSocketChannel.class);
            CompletableFuture<@Nullable ConnectionResult> cf = CompletableFuture.supplyAsync(() -> {
                try {
                    AFGenericSocketChannel sc = gssc.accept();
                    ByteBuffer bb = ByteBuffer.allocate(64);
                    int r = sc.read(bb);
                    if (r != 1) {
                        throw new IllegalStateException("Unexpected result: " + r + " bytes read");
                    }
                    return new ConnectionResult(bb.get(0), (AFGenericSocketAddress)sc.getLocalSocketAddress(), (AFGenericSocketAddress)sc.getRemoteSocketAddress());
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            });
            try (AFUNIXSocket sock = AFUNIXSocket.connectTo((AFUNIXSocketAddress)((AFUNIXSocketAddress)ussc.getLocalAddress()));){
                AFGenericSocketAddress rsa;
                AFGenericSocket gs = (AFGenericSocket)FileDescriptorCast.using((FileDescriptor)sock.getFileDescriptor()).as(AFGenericSocket.class);
                try {
                    gs.getOutputStream().write(123);
                }
                catch (BrokenPipeSocketException e) {
                    try {
                        cf.get();
                    }
                    catch (Exception e2) {
                        e.addSuppressed((Throwable)e2);
                    }
                    throw e;
                }
                AFGenericSocketAddress lsa = (AFGenericSocketAddress)gs.getLocalSocketAddress();
                if (lsa != null) {
                    Assertions.assertEquals(AFGenericSocketAddress.class, lsa.getClass());
                }
                if ((rsa = (AFGenericSocketAddress)gs.getRemoteSocketAddress()) != null) {
                    Assertions.assertEquals(AFGenericSocketAddress.class, rsa.getClass());
                }
                ConnectionResult cr = Objects.requireNonNull(cf.get());
                Assertions.assertEquals((int)123, (int)cr.firstByte);
                if (lsa != null) {
                    this.compareGenericAddresses(lsa, cr.remoteSocketAddress);
                }
                if (rsa != null) {
                    this.compareGenericAddresses(rsa, cr.localSocketAddress);
                }
            }
        }
    }

    private void compareGenericAddresses(AFGenericSocketAddress rsa, SocketAddress lsa) {
        if (rsa.toBytes().length >= 2 || rsa.equals((Object)lsa)) {
            if (!rsa.equals((Object)lsa) && lsa instanceof AFGenericSocketAddress) {
                byte[] bytesRemote = rsa.getBytes();
                byte[] bytesLocal = ((AFGenericSocketAddress)lsa).getBytes();
                int minLength = Math.min(bytesRemote.length, bytesLocal.length);
                boolean ok = true;
                for (int i = 0; i < minLength; ++i) {
                    if (bytesRemote[i] == bytesLocal[i]) continue;
                    ok = false;
                    break;
                }
                if (!ok) {
                    Assertions.assertEquals((Object)rsa, (Object)lsa);
                }
            } else {
                Assertions.assertEquals((Object)rsa, (Object)lsa);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AFSocketCapabilityRequirement(value={AFSocketCapability.CAPABILITY_UNIX_DOMAIN})
    @Test
    public void testCastGenericDuplicating() throws Exception {
        AFUNIXSocketAddress addr = AFUNIXSocketAddress.ofNewTempFile();
        Path p = addr.getFile().toPath();
        try (AFUNIXServerSocketChannel ussc = AFUNIXServerSocketChannel.open();){
            ussc.bind((SocketAddress)addr);
            FileDescriptorCast fdc = FileDescriptorCast.duplicating((FileDescriptor)ussc.getFileDescriptor());
            if (fdc == null) {
                throw new TestAbortedNotAnIssueException("FileDescriptCast.duplicating not supported");
            }
            AFGenericServerSocketChannel gssc = (AFGenericServerSocketChannel)fdc.as(AFGenericServerSocketChannel.class);
            CompletableFuture<@Nullable ConnectionResult> cf = CompletableFuture.supplyAsync(() -> {
                try {
                    AFGenericSocketChannel sc = gssc.accept();
                    ByteBuffer bb = ByteBuffer.allocate(64);
                    int r = sc.read(bb);
                    if (r != 1) {
                        throw new IllegalStateException("Unexpected result: " + r + " bytes read");
                    }
                    return new ConnectionResult(bb.get(0), (AFGenericSocketAddress)sc.getLocalSocketAddress(), (AFGenericSocketAddress)sc.getRemoteSocketAddress());
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            });
            try (AFUNIXSocket sock = AFUNIXSocket.connectTo((AFUNIXSocketAddress)((AFUNIXSocketAddress)ussc.getLocalAddress()));){
                AFGenericSocketAddress rsa;
                AFGenericSocket gs = (AFGenericSocket)FileDescriptorCast.using((FileDescriptor)sock.getFileDescriptor()).as(AFGenericSocket.class);
                try {
                    gs.getOutputStream().write(123);
                }
                catch (BrokenPipeSocketException e) {
                    try {
                        cf.get();
                    }
                    catch (Exception e2) {
                        e.addSuppressed((Throwable)e2);
                    }
                    throw e;
                }
                AFGenericSocketAddress lsa = (AFGenericSocketAddress)gs.getLocalSocketAddress();
                if (lsa != null) {
                    Assertions.assertEquals(AFGenericSocketAddress.class, lsa.getClass());
                }
                if ((rsa = (AFGenericSocketAddress)gs.getRemoteSocketAddress()) != null) {
                    Assertions.assertEquals(AFGenericSocketAddress.class, rsa.getClass());
                }
                ConnectionResult cr = Objects.requireNonNull(cf.get());
                Assertions.assertEquals((int)123, (int)cr.firstByte);
                if (lsa != null) {
                    this.compareGenericAddresses(lsa, cr.remoteSocketAddress);
                }
                if (rsa != null) {
                    this.compareGenericAddresses(rsa, cr.localSocketAddress);
                }
            }
        }
        finally {
            Files.deleteIfExists(p);
        }
    }

    @AFSocketCapabilityRequirement(value={AFSocketCapability.CAPABILITY_UNIX_DOMAIN})
    @Test
    public void testCastToServerSocketIsSameType() throws Exception {
        AFUNIXServerSocketChannel ussc = AFUNIXServerSocketChannel.open();
        ussc.bind((SocketAddress)AFUNIXSocketAddress.ofNewTempFile());
        ServerSocketChannel ssc = (ServerSocketChannel)FileDescriptorCast.using((FileDescriptor)ussc.getFileDescriptor()).as(ServerSocketChannel.class);
        Assertions.assertEquals(AFUNIXServerSocketChannel.class, ssc.getClass());
        AFUNIXSocket us = AFUNIXSocket.connectTo((AFUNIXSocketAddress)((AFUNIXSocketAddress)ussc.getLocalAddress()));
        Socket s = (Socket)FileDescriptorCast.using((FileDescriptor)us.getFileDescriptor()).as(Socket.class);
        Assertions.assertEquals(AFUNIXSocket.class, s.getClass());
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class ConnectionResult {
        private final int firstByte;
        private final SocketAddress localSocketAddress;
        private final SocketAddress remoteSocketAddress;

        public ConnectionResult(int firstByte, AFGenericSocketAddress localSocketAddress, AFGenericSocketAddress remoteSocketAddress) {
            this.firstByte = firstByte;
            this.localSocketAddress = localSocketAddress;
            this.remoteSocketAddress = remoteSocketAddress;
        }
    }
}

