/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.domain;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.newsclub.net.unix.AFDatagramSocket;
import org.newsclub.net.unix.AFSelectorProvider;
import org.newsclub.net.unix.AFServerSocket;
import org.newsclub.net.unix.AFSocket;
import org.newsclub.net.unix.AFSocketAddress;
import org.newsclub.net.unix.AFUNIXDatagramSocket;
import org.newsclub.net.unix.AFUNIXSelectorProvider;
import org.newsclub.net.unix.AFUNIXServerSocket;
import org.newsclub.net.unix.AFUNIXServerSocketChannel;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.AFUNIXSocketChannel;
import org.newsclub.net.unix.AFUNIXSocketPair;
import org.newsclub.net.unix.AddressSpecifics;
import org.newsclub.net.unix.CloseablePair;
import org.newsclub.net.unix.SocketTestBase;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class AFUNIXAddressSpecifics
implements AddressSpecifics<AFUNIXSocketAddress> {
    public static final AddressSpecifics<AFUNIXSocketAddress> INSTANCE = new AFUNIXAddressSpecifics();

    private AFUNIXAddressSpecifics() {
    }

    public AFSocketAddress newTempAddress() throws IOException {
        return AFUNIXSocketAddress.ofNewTempFile();
    }

    public AFSocket<?> newSocket() throws IOException {
        return AFUNIXSocket.newInstance();
    }

    public AFSocket<?> newStrictSocket() throws IOException {
        return AFUNIXSocket.newStrictInstance();
    }

    public AFDatagramSocket<?> newDatagramSocket() throws IOException {
        return AFUNIXDatagramSocket.newInstance();
    }

    @Override
    public SocketChannel newSocketChannel() throws IOException {
        return AFUNIXSocketChannel.open();
    }

    @Override
    public DatagramChannel newDatagramChannel() throws IOException {
        return AFUNIXDatagramSocket.newInstance().getChannel();
    }

    public AFServerSocket<?> newServerSocket() throws IOException {
        return AFUNIXServerSocket.newInstance();
    }

    public AFSocketAddress newTempAddressForDatagram() throws IOException {
        return AFUNIXSocketAddress.of((File)SocketTestBase.newTempFile());
    }

    public AFSocketAddress unwrap(InetAddress addr, int port) throws SocketException {
        return AFUNIXSocketAddress.unwrap((InetAddress)addr, (int)port);
    }

    public AFSelectorProvider<?> selectorProvider() {
        return AFUNIXSelectorProvider.provider();
    }

    @Override
    public CloseablePair<? extends SocketChannel> newSocketPair() throws IOException {
        return AFUNIXSocketPair.open();
    }

    @Override
    public CloseablePair<? extends DatagramChannel> newDatagramSocketPair() throws IOException {
        return AFUNIXSocketPair.openDatagram();
    }

    public AFServerSocket<?> newServerSocketBindOn(SocketAddress addr) throws IOException {
        return AFUNIXServerSocket.bindOn((AFUNIXSocketAddress)((AFUNIXSocketAddress)addr));
    }

    public AFServerSocket<?> newServerSocketBindOn(SocketAddress addr, boolean deleteOnClose) throws IOException {
        return AFUNIXServerSocket.bindOn((AFUNIXSocketAddress)((AFUNIXSocketAddress)addr), (boolean)deleteOnClose);
    }

    @Override
    public Socket connectTo(SocketAddress socket) throws IOException {
        return AFUNIXSocket.connectTo((AFUNIXSocketAddress)((AFUNIXSocketAddress)socket));
    }

    @Override
    public String addressFamilyString() {
        return "AF_UNIX";
    }

    @Override
    public String summaryImportantMessage(String message) {
        return message;
    }

    @Override
    public ServerSocketChannel newServerSocketChannel() throws IOException {
        return AFUNIXServerSocketChannel.open();
    }
}

