/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import com.kohlschutter.testutil.TestAbortedWithImportantMessageException;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.BindException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.nio.file.Files;
import java.util.Random;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeEach;
import org.newsclub.net.unix.AFSocket;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AddressSpecifics;
import org.newsclub.net.unix.CloseablePair;
import org.newsclub.net.unix.java.JavaAddressSpecifics;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@SuppressFBWarnings(value={"THROWS_METHOD_THROWS_CLAUSE_THROWABLE", "THROWS_METHOD_THROWS_CLAUSE_BASIC_EXCEPTION"})
public abstract class SocketTestBase<A extends SocketAddress> {
    private static final Pattern PAT_LINUX_VERSION = Pattern.compile("^([0-9]+)\\.([0-9]+)\\.");
    private static final File SOCKET_FILE = SocketTestBase.initSocketFile();
    private static final Random RANDOM = new Random();
    private final SocketAddress serverAddress;
    private Exception caller = new Exception();
    private final AddressSpecifics<A> asp;

    protected SocketTestBase(AddressSpecifics<A> asp) {
        this.asp = asp;
        try {
            this.serverAddress = this.newTempAddress();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Deprecated
    protected final void finalize() {
    }

    private static File initSocketFile() {
        return SocketTestBase.newTempFile(System.getProperty("org.newsclub.net.unix.testsocket"));
    }

    public static File socketFile() {
        return SOCKET_FILE;
    }

    protected SocketAddress newTempAddress() throws IOException {
        return this.asp.newTempAddress();
    }

    @BeforeEach
    public void ensureSocketFileIsDeleted() throws IOException {
        Files.deleteIfExists(SOCKET_FILE.toPath());
    }

    @AfterAll
    public static void tearDownClass() throws IOException {
        Files.deleteIfExists(SOCKET_FILE.toPath());
    }

    public static File newTempFile() {
        return SocketTestBase.newTempFile(null);
    }

    public static File newTempFile(String name) {
        File f;
        try {
            f = name == null ? File.createTempFile("jutest", ".sock") : new File(name);
            f.deleteOnExit();
        }
        catch (IOException e) {
            throw new IllegalStateException("Can't create temporary file", e);
        }
        if (!f.delete()) {
            throw new IllegalStateException("Could not delete temporary file that we just created: " + String.valueOf(f));
        }
        return f;
    }

    protected ServerSocket startServer() throws IOException {
        this.caller = new Exception("Test server stacktrace");
        ServerSocket server = this.newServerSocket();
        SocketAddress bindAddr = this.getServerBindAddress();
        try {
            this.asp.bindServerSocket(server, this.getServerBindAddress());
        }
        catch (BindException e) {
            if (this.asp instanceof JavaAddressSpecifics && ((InetSocketAddress)bindAddr).getPort() == 0) {
                this.asp.bindServerSocket(server, null);
            }
            throw e;
        }
        return server;
    }

    protected boolean shouldDoConnectionCheckUponAccept() {
        return false;
    }

    protected void sleepFor(int ms) throws InterruptedIOException {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw (InterruptedIOException)new InterruptedIOException("sleep interrupted").initCause(e);
        }
    }

    protected final SocketAddress getServerBindAddress() {
        return this.serverAddress;
    }

    protected final Socket newSocket() throws IOException {
        return this.asp.newSocket();
    }

    protected final Socket newConnectedSocket(SocketAddress addr) throws IOException {
        Socket s = this.asp.newSocket();
        s.connect(addr);
        return s;
    }

    protected final SocketChannel newSocketChannel() throws IOException {
        return this.asp.newSocketChannel();
    }

    protected final Socket newStrictSocket() throws IOException {
        return this.asp.newStrictSocket();
    }

    protected final DatagramSocket newDatagramSocket() throws IOException {
        return this.asp.newDatagramSocket();
    }

    protected final DatagramChannel newDatagramChannel() throws IOException {
        return this.asp.newDatagramChannel();
    }

    protected final ServerSocket newServerSocket() throws IOException {
        return this.asp.newServerSocket();
    }

    protected ServerSocketChannel newServerSocketChannel() throws IOException {
        return this.asp.newServerSocketChannel();
    }

    protected ServerSocketChannel newServerSocketChannelBindOn(SocketAddress addr) throws IOException {
        ServerSocketChannel ssc = this.asp.newServerSocketChannel();
        ssc.bind(addr);
        return ssc;
    }

    protected final ServerSocket newServerSocketBindOn(SocketAddress addr) throws IOException {
        return this.asp.newServerSocketBindOn(addr);
    }

    protected final ServerSocket newServerSocketBindOn(SocketAddress addr, boolean deleteOnClose) throws IOException {
        return this.asp.newServerSocketBindOn(addr, deleteOnClose);
    }

    protected final SocketAddress newTempAddressForDatagram() throws IOException {
        return this.asp.newTempAddressForDatagram();
    }

    protected final SocketAddress unwrap(InetAddress addr, int port) throws SocketException {
        return this.asp.unwrap(addr, port);
    }

    protected final SelectorProvider selectorProvider() throws IOException {
        return this.asp.selectorProvider();
    }

    protected CloseablePair<? extends SocketChannel> newSocketPair() throws IOException {
        return this.asp.newSocketPair();
    }

    protected CloseablePair<? extends DatagramChannel> newDatagramSocketPair() throws IOException {
        return this.asp.newDatagramSocketPair();
    }

    protected Socket connectTo(SocketAddress endpoint) throws IOException {
        return this.asp.connectTo(endpoint);
    }

    protected final void bindServerSocket(ServerSocket serverSocket, SocketAddress bindpoint) throws IOException {
        this.asp.bindServerSocket(serverSocket, bindpoint);
    }

    protected final void bindServerSocket(ServerSocketChannel serverSocketChannel, SocketAddress bindpoint) throws IOException {
        this.asp.bindServerSocket(serverSocketChannel, bindpoint);
    }

    protected final void bindServerSocket(ServerSocketChannel serverSocketChannel, SocketAddress bindpoint, int backlog) throws IOException {
        this.asp.bindServerSocket(serverSocketChannel, bindpoint, backlog);
    }

    protected final void connectSocket(Socket socket, SocketAddress endpoint) throws IOException {
        this.asp.connectSocket(socket, endpoint);
    }

    protected final boolean connectSocket(SocketChannel socketChannel, SocketAddress endpoint) throws IOException {
        try {
            return this.asp.connectSocket(socketChannel, endpoint);
        }
        catch (IOException | IllegalStateException e) {
            throw this.handleConnectSocketException(socketChannel, endpoint, e);
        }
    }

    protected IOException handleConnectSocketException(SocketChannel socketChannel, SocketAddress endpoint, Exception e) {
        if (e instanceof IOException) {
            return (IOException)e;
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw new IllegalStateException(e);
    }

    protected CloseablePair<? extends Socket> newInterconnectedSockets() throws IOException {
        return this.asp.newInterconnectedSockets();
    }

    protected String addressFamilyString() {
        return this.asp.addressFamilyString();
    }

    protected Random getRandom() {
        return RANDOM;
    }

    protected int[] getLinuxMajorMinorVersion() {
        if (!"Linux".equals(System.getProperty("os.name"))) {
            return null;
        }
        Matcher m = PAT_LINUX_VERSION.matcher(System.getProperty("os.version", ""));
        if (m.find()) {
            return new int[]{Integer.parseInt(m.group(1)), Integer.parseInt(m.group(2))};
        }
        return null;
    }

    protected String summaryImportantMessage(String message) {
        return this.asp.summaryImportantMessage(message);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    protected abstract class AFUNIXServerThread
    extends ServerThread {
        protected AFUNIXServerThread() throws IOException, InterruptedException {
        }

        @Override
        protected final void handleConnection(Socket sock) throws IOException {
            this.handleConnection((AFUNIXSocket)sock);
        }

        protected abstract void handleConnection(AFUNIXSocket var1) throws IOException;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    protected abstract class ServerThread
    extends Thread
    implements AutoCloseable {
        private final ServerSocket serverSocket;
        private volatile Exception exception = null;
        private volatile Error error = null;
        private final AtomicBoolean loop = new AtomicBoolean(true);
        private final Semaphore sema = new Semaphore(1);
        private final Semaphore readySema = new Semaphore(0);

        @SuppressFBWarnings(value={"SC_START_IN_CTOR"})
        protected ServerThread() throws IOException, InterruptedException {
            this.serverSocket = this.startServer();
            this.setDaemon(true);
            this.start();
            this.readySema.acquire();
        }

        @Deprecated
        protected final void finalize() {
        }

        @Override
        public final void start() {
            super.start();
        }

        protected ServerSocket startServer() throws IOException {
            return SocketTestBase.this.startServer();
        }

        @Override
        public void close() throws Exception {
            this.shutdown();
            this.checkException();
        }

        public void shutdown() throws IOException {
            this.stopAcceptingConnections();
            if (this.serverSocket != null) {
                this.onServerSocketClose();
                this.serverSocket.close();
            }
        }

        protected abstract void handleConnection(Socket var1) throws IOException;

        protected void stopAcceptingConnections() {
            this.loop.set(false);
        }

        protected void onServerSocketClose() {
            this.stopAcceptingConnections();
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
        public ServerSocket getServerSocket() {
            return this.serverSocket;
        }

        public SocketAddress getServerAddress() {
            return this.getServerSocket().getLocalSocketAddress();
        }

        protected ExceptionHandlingDecision handleException(Exception e) {
            return ExceptionHandlingDecision.RAISE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void acceptAndHandleConnection() throws IOException {
            block19: {
                boolean acceptSuccess = false;
                this.sema.release();
                try (Socket sock = this.serverSocket.accept();){
                    try {
                        this.sema.acquire();
                    }
                    catch (InterruptedException e) {
                        throw (InterruptedIOException)new InterruptedIOException(e.getMessage()).initCause(e);
                    }
                    acceptSuccess = true;
                    if (sock instanceof AFSocket) {
                        AFSocket afs = (AFSocket)sock;
                        if (SocketTestBase.this.shouldDoConnectionCheckUponAccept() && afs.checkConnectionClosed()) {
                            acceptSuccess = false;
                        }
                    }
                    if (acceptSuccess) {
                        this.handleConnection(sock);
                    }
                }
                catch (IOException e) {
                    if (!acceptSuccess) {
                        if (this.serverSocket.isClosed()) {
                            this.stopAcceptingConnections();
                        }
                        break block19;
                    }
                    throw e;
                }
                finally {
                    if (acceptSuccess) {
                        this.sema.release();
                    }
                }
            }
        }

        @Override
        public final void run() {
            try {
                this.loop.set(true);
                this.readySema.release();
                this.onServerReady();
                while (this.loop.get()) {
                    this.acceptAndHandleConnection();
                }
            }
            catch (Exception e) {
                if (this.loop.get() && this.handleException(e) != ExceptionHandlingDecision.IGNORE) {
                    if (e instanceof TimeoutException && SocketTestBase.this.caller instanceof TestAbortedWithImportantMessageException) {
                        SocketTestBase.this.caller.addSuppressed(e);
                        this.exception = SocketTestBase.this.caller;
                    } else {
                        e.addSuppressed(SocketTestBase.this.caller);
                        this.exception = e;
                    }
                }
            }
            catch (Error e) {
                this.error = e;
            }
        }

        protected void onServerReady() {
        }

        public void checkException() throws Exception {
            boolean serverStillRunning;
            boolean bl = serverStillRunning = !this.sema.tryAcquire(30L, TimeUnit.SECONDS);
            if (this.error != null) {
                throw this.error;
            }
            if (this.exception != null) {
                throw this.exception;
            }
            if (serverStillRunning) {
                throw new IllegalStateException("SocketTestBase server still running after 30 seconds");
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    protected static enum ExceptionHandlingDecision {
        RAISE,
        IGNORE;

    }
}

