/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import com.kohlschutter.testutil.TestAbortedNotAnIssueException;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ServerSocketChannel;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.newsclub.net.unix.AddressSpecifics;
import org.newsclub.net.unix.SocketClosedByInterruptException;
import org.newsclub.net.unix.SocketTestBase;
import org.newsclub.net.unix.ThreadUtil;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@TestMethodOrder(value=MethodOrderer.MethodName.class)
public abstract class InterruptTest<A extends SocketAddress>
extends SocketTestBase<A> {
    protected InterruptTest(AddressSpecifics<A> asp) {
        super(asp);
    }

    @Test
    public void testInterruptSocketVirtualThread() throws Exception {
        if (!ThreadUtil.isVirtualThreadSupported()) {
            throw new TestAbortedNotAnIssueException("Virtual Threads are not supported by this JVM");
        }
        try (ServerSocket serverSocket = this.newServerSocketBindOn(this.newTempAddress());){
            CompletableFuture myThread = new CompletableFuture();
            CompletableFuture result = new CompletableFuture();
            ExecutorService executor = ThreadUtil.newVirtualThreadPerTaskExecutor();
            executor.submit(() -> {
                myThread.complete(Thread.currentThread());
                boolean closedByInterrupt = false;
                try {
                    serverSocket.accept();
                }
                catch (SocketClosedByInterruptException e) {
                    if (Thread.interrupted()) {
                        closedByInterrupt = true;
                    } else {
                        e.printStackTrace();
                    }
                }
                catch (SocketException e) {
                    if ("Closed by interrupt".equals(e.getMessage()) && Thread.interrupted() && serverSocket.isClosed()) {
                        closedByInterrupt = true;
                    } else {
                        e.printStackTrace();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    result.complete(closedByInterrupt);
                }
            });
            Thread t = (Thread)myThread.get();
            t.interrupt();
            Assertions.assertTrue((boolean)((Boolean)result.get()), (String)"Thread should have thrown a \"Closed by interrupt\" SocketException, the server socket should be closed, and the interrupt state should be set");
            executor.shutdownNow();
            Assertions.assertTrue((boolean)executor.awaitTermination(1L, TimeUnit.SECONDS));
        }
    }

    @Test
    public void testInterruptSocketChannelVirtualThread() throws Exception {
        if (!ThreadUtil.isVirtualThreadSupported()) {
            throw new TestAbortedNotAnIssueException("Virtual Threads are not supported by this JVM");
        }
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(10L), () -> {
            try (ServerSocketChannel serverSocketChannel = this.newServerSocketChannelBindOn(this.newTempAddress());){
                serverSocketChannel.configureBlocking(true);
                CompletableFuture myThread = new CompletableFuture();
                CompletableFuture result = new CompletableFuture();
                ExecutorService executor = ThreadUtil.newVirtualThreadPerTaskExecutor();
                executor.submit(() -> {
                    myThread.complete(Thread.currentThread());
                    boolean closedByInterrupt = false;
                    try {
                        serverSocketChannel.accept();
                    }
                    catch (ClosedByInterruptException e) {
                        if (Thread.currentThread().isInterrupted()) {
                            closedByInterrupt = true;
                        } else {
                            e.printStackTrace();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    finally {
                        result.complete(closedByInterrupt);
                    }
                });
                Thread t = (Thread)myThread.get();
                t.interrupt();
                executor.shutdownNow();
                Assertions.assertTrue((boolean)executor.awaitTermination(1L, TimeUnit.SECONDS));
            }
        });
    }
}

