/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.domain;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import com.kohlschutter.testutil.TestAbortedNotAnIssueException;
import java.net.ProtocolFamily;
import java.net.SocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AFDatagramChannel;
import org.newsclub.net.unix.AFServerSocketChannel;
import org.newsclub.net.unix.AFSocketCapability;
import org.newsclub.net.unix.AFSocketCapabilityRequirement;
import org.newsclub.net.unix.AFSocketChannel;
import org.newsclub.net.unix.AFUNIXDatagramChannel;
import org.newsclub.net.unix.AFUNIXServerSocketChannel;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.AFUNIXSocketChannel;
import org.newsclub.net.unix.domain.AFUNIXAddressSpecifics;
import org.newsclub.net.unix.jep380.JEP380AddressSpecifics;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@AFSocketCapabilityRequirement(value={AFSocketCapability.CAPABILITY_UNIX_DOMAIN})
@SuppressFBWarnings(value={"NM_SAME_SIMPLE_NAME_AS_SUPERCLASS"})
public final class SocketChannelTest
extends org.newsclub.net.unix.SocketChannelTest<AFUNIXSocketAddress> {
    public SocketChannelTest() {
        super(AFUNIXAddressSpecifics.INSTANCE);
    }

    @Test
    public void testUnixDomainProtocolFamily() throws Exception {
        ProtocolFamily unix = JEP380AddressSpecifics.unixProtocolFamilyIfAvailable();
        if (unix == null) {
            throw new TestAbortedNotAnIssueException("StandardProtocolFamily.UNIX is not supported by this VM");
        }
        try (AbstractSelectableChannel ch = AFSocketChannel.open((ProtocolFamily)unix);){
            Assertions.assertEquals(AFUNIXSocketChannel.class, ch.getClass());
        }
        ch = AFServerSocketChannel.open((ProtocolFamily)unix);
        try {
            Assertions.assertEquals(AFUNIXServerSocketChannel.class, ch.getClass());
        }
        finally {
            if (ch != null) {
                ch.close();
            }
        }
        ch = AFDatagramChannel.open((ProtocolFamily)unix);
        try {
            Assertions.assertEquals(AFUNIXDatagramChannel.class, ch.getClass());
        }
        finally {
            if (ch != null) {
                ch.close();
            }
        }
    }

    @Override
    protected boolean mayTestBindNullThrowUnsupportedOperationException() {
        return false;
    }

    @Override
    protected boolean mayTestBindNullHaveNullLocalSocketAddress() {
        return false;
    }

    @Override
    protected void cleanupTestBindNull(ServerSocketChannel sc, SocketAddress addr) throws Exception {
    }
}

