/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import java.io.IOException;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AFAddressFamily;
import org.newsclub.net.unix.AFInetAddress;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.SocketTestBase;
import org.newsclub.net.unix.domain.AFUNIXAddressSpecifics;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class InetAddressTest
extends SocketTestBase<AFUNIXSocketAddress> {
    public InetAddressTest() {
        super(AFUNIXAddressSpecifics.INSTANCE);
    }

    @Test
    public void testFromToBytes() throws IOException {
        byte[] bytes = new byte[]{0, 1, 2, 3, 127, -1};
        Assertions.assertArrayEquals((byte[])bytes, (byte[])AFInetAddress.unwrapAddress((InetAddress)AFInetAddress.wrapAddress((byte[])bytes, (AFAddressFamily)AFUNIXSocketAddress.AF_UNIX), (AFAddressFamily)AFUNIXSocketAddress.AF_UNIX));
    }

    @Test
    public void testHostnameStringEndsWithJunixSocket() throws IOException {
        byte[] bytes = new byte[]{0, 1, 2, 3, 127, -1};
        Assertions.assertTrue((boolean)AFInetAddress.wrapAddress((byte[])bytes, (AFAddressFamily)AFUNIXSocketAddress.AF_UNIX).getHostName().endsWith(".junixsocket"));
    }

    @Test
    public void testHostnameString() throws IOException {
        Assertions.assertEquals((Object)"[%2Ftmp%2Ftest.sock.un.junixsocket", (Object)AFInetAddress.wrapAddress((byte[])"/tmp/test.sock".getBytes(StandardCharsets.UTF_8), (AFAddressFamily)AFUNIXSocketAddress.AF_UNIX).getHostName());
    }

    @Test
    public void testIsLoopbackAddress() throws IOException {
        Assertions.assertTrue((boolean)AFInetAddress.wrapAddress((byte[])"/tmp/test.sock".getBytes(StandardCharsets.UTF_8), (AFAddressFamily)AFUNIXSocketAddress.AF_UNIX).isLoopbackAddress());
    }
}

