/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.mysql;

import com.kohlschutter.testutil.TestAbortedWithImportantMessageException;
import com.mysql.cj.jdbc.exceptions.CommunicationsException;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.newsclub.net.mysql.MysqlCredentials;
import org.newsclub.net.unix.AFUNIXSocketAddress;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
abstract class MysqlSocketFactoryTestBase {
    MysqlSocketFactoryTestBase() {
    }

    @Test
    public void testDriverManagerConnectionToMissingServer() throws Exception {
        AFUNIXSocketAddress addr = AFUNIXSocketAddress.ofNewTempFile();
        try (Connection unused = DriverManager.getConnection("jdbc:mysql://localhost/db?socketFactory=" + this.socketFactory() + "&junixsocket.file=" + addr.getPath());){
            Assertions.fail((String)"Should have thrown an exception since we're trying to connect to a non-existing database server");
        }
        catch (CommunicationsException communicationsException) {
            // empty catch block
        }
    }

    @Test
    public void testDriverManagerConnectionToMysqlSock() throws Exception {
        MysqlCredentials creds = MysqlCredentials.getCredentials();
        AFUNIXSocketAddress addr = AFUNIXSocketAddress.of((File)new File("/tmp/mysql.sock"));
        boolean connected = false;
        try (Connection conn = DriverManager.getConnection("jdbc:mysql://localhost/mysql?socketFactory=" + this.socketFactory() + "&junixsocket.file=" + addr.getPath(), creds.getUser(), creds.getPassword());){
            connected = true;
            try (PreparedStatement pstmt = conn.prepareStatement("SHOW TABLES");
                 ResultSet rs = pstmt.executeQuery();){
                if (rs.next()) {
                    Assertions.assertNotNull((Object)rs.getString(1));
                }
            }
        }
        catch (SQLException e) {
            if (connected) {
                throw e;
            }
            throw new TestAbortedWithImportantMessageException(TestAbortedWithImportantMessageException.MessageType.TEST_ABORTED_WITH_ISSUES, "Could not connect to MySQL database for testing. Please correct the following definitions: " + creds.toString(), (Throwable)e);
        }
    }

    protected abstract String socketFactory();
}

