/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.rmi;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.net.SocketException;
import java.util.Objects;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.newsclub.net.unix.AFInputStream;
import org.newsclub.net.unix.AFOutputStream;
import org.newsclub.net.unix.AFServerSocket;
import org.newsclub.net.unix.AFSocket;
import org.newsclub.net.unix.AFSocketAddress;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.FileDescriptorAccess;
import org.newsclub.net.unix.rmi.AFUNIXRMISocketFactory;
import org.newsclub.net.unix.server.AFSocketServer;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class RemoteFileDescriptorBase<T>
implements Externalizable,
Closeable,
FileDescriptorAccess {
    private static final String PROP_SERVER_TIMEOUT = "org.newsclub.net.unix.rmi.rfd-server-timeout-millis";
    private static final String PROP_CONNECT_TIMEOUT = "org.newsclub.net.unix.rmi.rfd-connect-timeout-millis";
    private static final int SERVER_TIMEOUT = RemoteFileDescriptorBase.parseTimeoutMillis(System.getProperty("org.newsclub.net.unix.rmi.rfd-server-timeout-millis", "10000"), false);
    private static final int CONNECT_TIMEOUT = RemoteFileDescriptorBase.parseTimeoutMillis(System.getProperty("org.newsclub.net.unix.rmi.rfd-connect-timeout-millis", "1000"), true);
    static final int MAGIC_VALUE_MASK = 0xFD0000;
    static final int BIT_READABLE = 1;
    static final int BIT_WRITABLE = 2;
    private static final long serialVersionUID = 1L;
    private final AtomicReference<DataInputStream> remoteConnection = new AtomicReference();
    private final AtomicReference<AFUNIXSocket> remoteServer = new AtomicReference();
    protected final transient AtomicReference<T> resource = new AtomicReference();
    private int magicValue;
    private transient FileDescriptor fd;
    private AFUNIXRMISocketFactory socketFactory;

    public RemoteFileDescriptorBase() {
    }

    RemoteFileDescriptorBase(AFUNIXRMISocketFactory socketFactory, T stream, FileDescriptor fd, int magicValue) {
        this.resource.set(stream);
        this.socketFactory = socketFactory;
        this.fd = fd;
        this.magicValue = magicValue;
    }

    @Override
    public final void writeExternal(ObjectOutput objOut) throws IOException {
        int localPort;
        if (this.fd == null || !this.fd.valid()) {
            throw new IOException("No or invalid file descriptor");
        }
        final int randomValue = ThreadLocalRandom.current().nextInt();
        try {
            final AFServerSocket serverSocket = (AFServerSocket)this.socketFactory.createServerSocket(0);
            localPort = serverSocket.getLocalPort();
            AFSocketServer<AFSocketAddress> server = new AFSocketServer<AFSocketAddress>(serverSocket){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void doServeSocket(AFSocket<?> socket) throws IOException {
                    block17: {
                        AFUNIXSocket unixSocket = (AFUNIXSocket)socket;
                        try (DataOutputStream out = new DataOutputStream((OutputStream)socket.getOutputStream());
                             AFInputStream in = socket.getInputStream();){
                            unixSocket.setOutboundFileDescriptors(new FileDescriptor[]{RemoteFileDescriptorBase.this.fd});
                            out.writeInt(randomValue);
                            try {
                                socket.setSoTimeout(CONNECT_TIMEOUT);
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            int response = in.read();
                            if (response == 1) break block17;
                            if (response == -1) {
                                break block17;
                            }
                            throw new IOException("Unexpected response: " + response);
                        }
                        finally {
                            this.stop();
                        }
                    }
                }

                protected void onServerStopped(AFServerSocket<?> socket) {
                    try {
                        serverSocket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            };
            ScheduledFuture scheduledFuture = server.startThenStopAfter((long)SERVER_TIMEOUT, TimeUnit.MILLISECONDS);
        }
        catch (IOException e) {
            objOut.writeObject(e);
            throw e;
        }
        objOut.writeObject(this.socketFactory);
        objOut.writeInt(this.magicValue);
        objOut.writeInt(randomValue);
        objOut.writeInt(localPort);
        objOut.flush();
    }

    @Override
    public final void readExternal(ObjectInput objIn) throws IOException, ClassNotFoundException {
        Object obj;
        DataInputStream in1 = this.remoteConnection.getAndSet(null);
        if (in1 != null) {
            in1.close();
        }
        if ((obj = objIn.readObject()) instanceof IOException) {
            IOException e = new IOException("Could not read RemoteFileDescriptor");
            e.addSuppressed((IOException)obj);
            throw e;
        }
        this.socketFactory = (AFUNIXRMISocketFactory)obj;
        this.magicValue = objIn.readInt();
        if ((this.magicValue & 0xFD0000) != 0xFD0000) {
            throw new IOException("Unexpected magic value: " + Integer.toHexString(this.magicValue));
        }
        int randomValue = objIn.readInt();
        int port = objIn.readInt();
        AFUNIXSocket socket = (AFUNIXSocket)this.socketFactory.createSocket("", port);
        if (this.remoteServer.getAndSet(socket) != null) {
            throw new IllegalStateException("remoteServer was not null");
        }
        try {
            socket.setSoTimeout(CONNECT_TIMEOUT);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        in1 = new DataInputStream((InputStream)socket.getInputStream());
        this.remoteConnection.set(in1);
        socket.ensureAncillaryReceiveBufferSize(128);
        int random = in1.readInt();
        if (random != randomValue) {
            throw new IOException("Invalid socket connection");
        }
        FileDescriptor[] descriptors = socket.getReceivedFileDescriptors();
        if (descriptors == null || descriptors.length != 1) {
            throw new IOException("Did not receive exactly 1 file descriptor but " + (descriptors == null ? 0 : descriptors.length));
        }
        this.fd = descriptors[0];
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public final FileDescriptor getFileDescriptor() {
        return this.fd;
    }

    protected final int getMagicValue() {
        return this.magicValue;
    }

    @Override
    public void close() throws IOException {
        Object c;
        AFUNIXSocket remoteSocket;
        DataInputStream in1 = this.remoteConnection.getAndSet(null);
        if (in1 != null) {
            try {
                in1.close();
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
        if ((remoteSocket = (AFUNIXSocket)this.remoteServer.getAndSet(null)) != null) {
            try (AFOutputStream out2 = remoteSocket.getOutputStream();){
                out2.write(1);
            }
            catch (SocketException out2) {
                // empty catch block
            }
            remoteSocket.close();
        }
        if ((c = this.resource.getAndSet(null)) != null && c instanceof Closeable) {
            ((Closeable)c).close();
        }
    }

    private static int parseTimeoutMillis(String s, boolean zeroPermitted) {
        int duration;
        Objects.requireNonNull(s);
        try {
            duration = Integer.parseInt(s);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Illegal timeout value: " + s, e);
        }
        if (duration < 0 || duration == 0 && !zeroPermitted) {
            throw new IllegalArgumentException("Illegal timeout value: " + s);
        }
        return duration;
    }
}

