/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.rmi;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.newsclub.net.unix.rmi.AFNaming;
import org.newsclub.net.unix.rmi.AFNamingProvider;
import org.newsclub.net.unix.rmi.AFRegistry;
import org.newsclub.net.unix.rmi.AFUNIXRMISocketFactory;
import org.newsclub.net.unix.rmi.AFUNIXRegistry;
import org.newsclub.net.unix.rmi.ShutdownException;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class AFUNIXNaming
extends AFNaming {
    private static final String PROP_RMI_SOCKET_DIR = "org.newsclub.net.unix.rmi.socketdir";
    private static final File DEFAULT_SOCKET_DIRECTORY = new File(System.getProperty("org.newsclub.net.unix.rmi.socketdir", "/tmp"));
    private boolean deleteRegistrySocketDir = false;
    private final File registrySocketDir;
    private final RMIClientSocketFactory defaultClientSocketFactory;
    private final RMIServerSocketFactory defaultServerSocketFactory;
    private final String socketPrefix;
    private final String socketSuffix;

    private AFUNIXNaming(File socketDir, int registryPort, String socketPrefix, String socketSuffix) throws IOException {
        super(registryPort, 100002);
        Objects.requireNonNull(socketDir);
        this.registrySocketDir = socketDir;
        this.socketPrefix = socketPrefix;
        this.socketSuffix = socketSuffix;
        this.defaultClientSocketFactory = null;
        this.defaultServerSocketFactory = null;
    }

    public static File getDefaultSocketDirectory() {
        return DEFAULT_SOCKET_DIRECTORY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AFUNIXNaming newPrivateInstance() throws IOException {
        AFUNIXNaming instance;
        File tmpDir = Files.createTempDirectory("junixsocket-", new FileAttribute[0]).toFile();
        if (!tmpDir.canWrite()) {
            throw new IOException("Could not create temporary directory: " + String.valueOf(tmpDir));
        }
        AFUNIXNaming aFUNIXNaming = instance = AFUNIXNaming.getInstance(tmpDir, 100001);
        synchronized (aFUNIXNaming) {
            instance.deleteRegistrySocketDir = true;
        }
        return instance;
    }

    public static AFUNIXNaming getInstance() throws IOException {
        return AFUNIXNaming.getInstance(DEFAULT_SOCKET_DIRECTORY, 100001);
    }

    public static AFUNIXNaming getInstance(File socketDir) throws RemoteException {
        return AFUNIXNaming.getInstance(socketDir, 100001);
    }

    public static AFUNIXNaming getInstance(File socketDir, int registryPort) throws RemoteException {
        return AFUNIXNaming.getInstance(socketDir, registryPort, null, null);
    }

    public static AFUNIXNaming getInstance(File socketDir, int registryPort, String socketPrefix, String socketSuffix) throws RemoteException {
        return AFNaming.getInstance(registryPort, new AFUNIXNamingProvider(socketDir, socketPrefix, socketSuffix));
    }

    public static AFNaming getSingleFileInstance(File socketFile) throws IOException {
        return AFUNIXNaming.getInstance(socketFile, Integer.MAX_VALUE);
    }

    @Override
    public AFUNIXRMISocketFactory getSocketFactory() {
        return (AFUNIXRMISocketFactory)super.getSocketFactory();
    }

    @Override
    public AFRegistry getRegistry() throws RemoteException {
        return this.getRegistry(0L, TimeUnit.SECONDS);
    }

    @Override
    public AFUNIXRegistry getRegistry(long timeout, TimeUnit unit) throws RemoteException {
        return (AFUNIXRegistry)super.getRegistry(timeout, unit);
    }

    @Override
    public AFUNIXRegistry getRegistry(boolean create) throws RemoteException {
        return (AFUNIXRegistry)super.getRegistry(create);
    }

    @Override
    public AFUNIXRegistry createRegistry() throws RemoteException {
        return (AFUNIXRegistry)super.createRegistry();
    }

    public File getRegistrySocketFile() {
        return this.getSocketFactory().getFile(this.getRegistryPort());
    }

    @Override
    protected AFUNIXRMISocketFactory initSocketFactory() throws IOException {
        return new AFUNIXRMISocketFactory(this, this.registrySocketDir, this.defaultClientSocketFactory, this.defaultServerSocketFactory, this.socketPrefix, this.socketSuffix);
    }

    @Override
    protected AFUNIXRegistry newAFRegistry(Registry impl) throws RemoteException {
        return new AFUNIXRegistry(this, impl);
    }

    @Override
    protected AFRegistry openRegistry(long timeout, TimeUnit unit) throws RemoteException {
        AFUNIXRegistry reg;
        File socketFile = this.getRegistrySocketFile();
        if (!socketFile.exists() && this.waitUntilFileExists(socketFile, timeout, unit) && (reg = this.getRegistry(false)) != null) {
            return reg;
        }
        throw new ShutdownException("Could not find registry at " + String.valueOf(this.getRegistrySocketFile()));
    }

    private boolean waitUntilFileExists(File f, long timeout, TimeUnit unit) {
        try {
            for (long timeWait = unit.toMillis(timeout); timeWait > 0L && !f.exists(); timeWait -= 50L) {
                Thread.sleep(Math.min(50L, timeWait));
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return f.exists();
    }

    private synchronized void deleteSocketDir() {
        if (this.deleteRegistrySocketDir && this.registrySocketDir != null) {
            try {
                Files.delete(this.registrySocketDir.toPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    protected void shutdownRegistryFinishingTouches() {
        this.deleteSocketDir();
    }

    public File getRegistrySocketDir() {
        return this.registrySocketDir;
    }

    @Override
    protected void initRegistryPrerequisites() throws ServerException {
        if (this.registrySocketDir != null && !this.registrySocketDir.mkdirs() && !this.registrySocketDir.isDirectory()) {
            throw new ServerException("Cannot create socket directory:" + String.valueOf(this.registrySocketDir));
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class AFUNIXNamingProvider
    implements AFNamingProvider<AFUNIXNaming> {
        private final File socketDir;
        private final String socketPrefix;
        private final String socketSuffix;

        public AFUNIXNamingProvider(File socketDir, String socketPrefix, String socketSuffix) throws RemoteException {
            try {
                this.socketDir = socketDir.getCanonicalFile();
            }
            catch (IOException e) {
                throw new RemoteException(e.getMessage(), e);
            }
            this.socketPrefix = socketPrefix == null ? "" : socketPrefix;
            this.socketSuffix = socketSuffix == null ? ".rmi" : socketSuffix;
        }

        @Override
        public AFUNIXNaming newInstance(int port) throws IOException {
            return new AFUNIXNaming(this.socketDir, port, this.socketPrefix, this.socketSuffix);
        }
    }
}

