/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.rmi;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.newsclub.net.unix.AFSocket;
import org.newsclub.net.unix.AFSocketAddress;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.AFUNIXSocketCredentials;
import org.newsclub.net.unix.HostAndPort;
import org.newsclub.net.unix.rmi.AFNaming;
import org.newsclub.net.unix.rmi.AFRMISocketFactory;
import org.newsclub.net.unix.rmi.AFUNIXNaming;
import org.newsclub.net.unix.rmi.DefaultRMIClientSocketFactory;
import org.newsclub.net.unix.rmi.DefaultRMIServerSocketFactory;
import org.newsclub.net.unix.rmi.RemotePeerInfo;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class AFUNIXRMISocketFactory
extends AFRMISocketFactory {
    private static final long serialVersionUID = 1L;
    static final String DEFAULT_SOCKET_FILE_PREFIX = "";
    static final String DEFAULT_SOCKET_FILE_SUFFIX = ".rmi";
    private File socketDir;
    private String socketPrefix;
    private String socketSuffix;
    private final transient Map<HostAndPort, AFUNIXSocketCredentials> credentials = new HashMap<HostAndPort, AFUNIXSocketCredentials>();

    public AFUNIXRMISocketFactory() {
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public AFUNIXRMISocketFactory(AFNaming naming, File socketDir, RMIClientSocketFactory defaultClientFactory, RMIServerSocketFactory defaultServerFactory, String socketPrefix, String socketSuffix) throws IOException {
        super(naming, defaultClientFactory, defaultServerFactory);
        Objects.requireNonNull(socketDir);
        this.socketDir = socketDir;
        this.socketPrefix = socketPrefix == null ? DEFAULT_SOCKET_FILE_PREFIX : socketPrefix;
        this.socketSuffix = socketSuffix == null ? DEFAULT_SOCKET_FILE_SUFFIX : socketSuffix;
    }

    public AFUNIXRMISocketFactory(AFNaming naming, File socketDir, RMIClientSocketFactory defaultClientFactory, RMIServerSocketFactory defaultServerFactory) throws IOException {
        this(naming, socketDir, defaultClientFactory, defaultServerFactory, null, null);
    }

    public AFUNIXRMISocketFactory(AFNaming naming, File socketDir) throws IOException {
        this(naming, socketDir, DefaultRMIClientSocketFactory.getInstance(), DefaultRMIServerSocketFactory.getInstance());
    }

    @Override
    protected AFNaming readNamingInstance(ObjectInput in) throws IOException {
        this.socketDir = new File(in.readUTF());
        int port = in.readInt();
        return AFUNIXNaming.getInstance(this.socketDir, port);
    }

    @Override
    protected void writeNamingInstance(ObjectOutput out, AFNaming naming) throws IOException {
        out.writeUTF(this.socketDir.getAbsolutePath());
        out.writeInt(naming.getRegistryPort());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.socketPrefix = in.readUTF();
        this.socketSuffix = in.readUTF();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeUTF(this.socketPrefix);
        out.writeUTF(this.socketSuffix);
    }

    public int hashCode() {
        return this.socketDir == null ? super.hashCode() : this.socketDir.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof AFUNIXRMISocketFactory)) {
            return false;
        }
        AFUNIXRMISocketFactory sf = (AFUNIXRMISocketFactory)other;
        if (this.socketDir == null) {
            return sf == this;
        }
        return this.socketDir.equals(sf.socketDir);
    }

    public File getSocketDir() {
        return this.socketDir;
    }

    File getFile(int port) {
        if (this.isPlainFileSocket()) {
            return this.getSocketDir();
        }
        Objects.requireNonNull(this.socketDir);
        return new File(this.socketDir, this.socketPrefix + port + this.socketSuffix);
    }

    boolean hasSocketFile(int port) {
        return this.getFile(port).exists();
    }

    private boolean isPlainFileSocket() {
        return this.getNaming().getRegistryPort() == Integer.MAX_VALUE;
    }

    protected AFUNIXSocketAddress newSocketAddress(int port) throws IOException {
        return AFUNIXSocketAddress.of((File)this.getFile(port), (int)port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final AFSocket<?> newConnectedSocket(AFSocketAddress addr) throws IOException {
        AFUNIXSocket socket = ((AFUNIXSocketAddress)addr).newConnectedSocket();
        AFUNIXSocketCredentials creds = socket.getPeerCredentials();
        HostAndPort hap = new HostAndPort(addr.getHostString(), addr.getPort());
        Map<HostAndPort, AFUNIXSocketCredentials> map = this.credentials;
        synchronized (map) {
            if (this.credentials.put(hap, creds) != null) {
                // empty if block
            }
        }
        socket.addCloseable(() -> {
            Map<HostAndPort, AFUNIXSocketCredentials> map = this.credentials;
            synchronized (map) {
                this.credentials.remove(hap);
            }
        });
        return socket;
    }

    public String toString() {
        return super.toString() + "[path=" + String.valueOf(this.socketDir) + (String)(this.isPlainFileSocket() ? DEFAULT_SOCKET_FILE_PREFIX : ";prefix=" + this.socketPrefix + ";suffix=" + this.socketSuffix) + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Map<HostAndPort, AFUNIXSocketCredentials> map = this.credentials;
        synchronized (map) {
            this.credentials.clear();
        }
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AFUNIXSocketCredentials peerCredentialsFor(RemotePeerInfo data) {
        Map<HostAndPort, AFUNIXSocketCredentials> map = this.credentials;
        synchronized (map) {
            return this.credentials.get(new HostAndPort(data.host, data.port));
        }
    }

    @Override
    boolean hasRegisteredPort(int port) {
        return this.hasSocketFile(port);
    }
}

