/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.rmi;

import java.io.IOException;
import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.ConnectIOException;
import java.rmi.NoSuchObjectException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteServer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.newsclub.net.unix.rmi.AFUNIXNaming;
import org.newsclub.net.unix.rmi.AFUNIXRMIService;
import org.newsclub.net.unix.rmi.RemoteCloseable;
import org.newsclub.net.unix.rmi.ShutdownHookSupport;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class AFUNIXRegistry
implements Registry {
    final RemoteCloseable<?> boundCloser;
    private final Registry impl;
    private final Map<String, Remote> bound = new HashMap<String, Remote>();
    private final AFUNIXNaming naming;
    private boolean boundCloserExported = false;

    AFUNIXRegistry(AFUNIXNaming naming, Registry impl) throws RemoteException {
        this.naming = naming;
        this.impl = impl;
        this.boundCloser = new RemoteCloseable<Void>(){

            @Override
            public Void get() throws IOException {
                return null;
            }

            @Override
            public void close() throws IOException {
                AFUNIXRegistry.this.forceUnexportBound();
            }
        };
        if (this.isLocal()) {
            ShutdownHookSupport.addWeakShutdownHook(new ShutdownHookSupport.ShutdownHook(){

                @Override
                public void onRuntimeShutdown(Thread thread) {
                    AFUNIXRegistry.this.forceUnexportBound();
                }
            });
        }
    }

    @Deprecated
    public boolean isRemoteServer() {
        return this.isLocal();
    }

    public boolean isLocal() {
        return this.impl instanceof RemoteServer;
    }

    public AFUNIXNaming getNaming() {
        return this.naming;
    }

    @Override
    public Remote lookup(String name) throws RemoteException, NotBoundException, AccessException {
        return this.impl.lookup(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bind(String name, Remote obj) throws RemoteException, AlreadyBoundException, AccessException {
        this.impl.bind(name, RemoteObject.toStub(obj));
        Map<String, Remote> map = this.bound;
        synchronized (map) {
            this.bound.put(name, obj);
        }
        this.checkBound();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbind(String name) throws RemoteException, NotBoundException, AccessException {
        this.impl.unbind(name);
        Map<String, Remote> map = this.bound;
        synchronized (map) {
            this.bound.remove(name);
        }
        this.checkBound();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rebind(String name, Remote obj) throws RemoteException, AccessException {
        this.impl.rebind(name, RemoteObject.toStub(obj));
        Map<String, Remote> map = this.bound;
        synchronized (map) {
            this.bound.put(name, obj);
        }
        this.checkBound();
    }

    @Override
    public String[] list() throws RemoteException, AccessException {
        return this.impl == null ? new String[]{} : this.impl.list();
    }

    public Remote lookup(String name, long timeout, TimeUnit unit) throws NotBoundException, RemoteException {
        long timeWait = unit.toMillis(timeout);
        Exception exFirst = null;
        while (true) {
            try {
                return this.impl.lookup(name);
            }
            catch (ConnectIOException | NoSuchObjectException | NotBoundException e) {
                block8: {
                    if (exFirst == null) {
                        exFirst = e;
                    }
                    try {
                        Thread.sleep(Math.min(timeWait, 50L));
                        continue;
                    }
                    catch (InterruptedException e1) {
                        exFirst.addSuppressed(e1);
                        break block8;
                    }
                    if ((timeWait -= 50L) > 0L) continue;
                }
                if (exFirst instanceof NotBoundException) {
                    throw (NotBoundException)exFirst;
                }
                if (exFirst instanceof RemoteException) {
                    throw (RemoteException)exFirst;
                }
                throw new RemoteException("Lookup timed out");
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forceUnexportBound() {
        HashMap<String, Remote> map;
        String[] stringArray = this.bound;
        synchronized (stringArray) {
            map = new HashMap<String, Remote>(this.bound);
            this.bound.clear();
        }
        try {
            this.checkBound();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        for (Map.Entry entry : map.entrySet()) {
            String name = (String)entry.getKey();
            Remote obj = (Remote)entry.getValue();
            if (obj == null) continue;
            AFUNIXNaming.unexportObject(obj);
            try {
                this.unbind(name);
            }
            catch (NotBoundException | RemoteException exception) {}
        }
        try {
            for (String list : this.list()) {
                try {
                    this.unbind(list);
                }
                catch (NotBoundException | RemoteException exception) {
                    // empty catch block
                }
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        AFUNIXNaming.unexportObject(this.impl);
        AFUNIXNaming.unexportObject(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkBound() throws RemoteException {
        AFUNIXRMIService service;
        boolean empty;
        Map<String, Remote> map = this.bound;
        synchronized (map) {
            empty = this.bound.isEmpty();
        }
        if (empty) {
            if (this.boundCloserExported) {
                this.boundCloserExported = false;
                try {
                    service = this.naming.getRMIService(this);
                    service.unregisterForShutdown(this.boundCloser);
                }
                catch (NoSuchObjectException | NotBoundException e) {
                    return;
                }
                finally {
                    AFUNIXNaming.unexportObject(this.boundCloser);
                }
            }
        } else if (!this.boundCloserExported) {
            AFUNIXNaming.exportObject(this.boundCloser, this.naming.getSocketFactory());
            this.boundCloserExported = true;
            try {
                service = this.naming.getRMIService(this);
            }
            catch (NotBoundException e) {
                return;
            }
            service.registerForShutdown(this.boundCloser);
        }
    }
}

