/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.rmi;

import java.io.Closeable;
import java.io.Externalizable;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.file.Files;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RMISocketFactory;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import org.newsclub.net.unix.AFUNIXServerSocket;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.AFUNIXSocketCredentials;
import org.newsclub.net.unix.rmi.AFUNIXNaming;
import org.newsclub.net.unix.rmi.AFUNIXRMIService;
import org.newsclub.net.unix.rmi.DefaultRMIClientSocketFactory;
import org.newsclub.net.unix.rmi.DefaultRMIServerSocketFactory;
import org.newsclub.net.unix.rmi.RemotePeerInfo;
import org.newsclub.net.unix.rmi.ShutdownHookSupport;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class AFUNIXRMISocketFactory
extends RMISocketFactory
implements Externalizable,
Closeable,
ShutdownHookSupport.ShutdownHook {
    static final String DEFAULT_SOCKET_FILE_PREFIX = "";
    static final String DEFAULT_SOCKET_FILE_SUFFIX = ".rmi";
    private static final long serialVersionUID = 1L;
    private RMIClientSocketFactory defaultClientFactory;
    private RMIServerSocketFactory defaultServerFactory;
    private File socketDir;
    private AFUNIXNaming naming;
    private String socketPrefix;
    private String socketSuffix;
    private AFUNIXRMIService rmiService = null;
    private Map<HostAndPort, AFUNIXSocketCredentials> credentials = new HashMap<HostAndPort, AFUNIXSocketCredentials>();
    private final BitSet openServerPorts = new BitSet();

    public AFUNIXRMISocketFactory() {
        this.closeUponRuntimeShutdown();
    }

    public AFUNIXRMISocketFactory(AFUNIXNaming naming, File socketDir) throws IOException {
        this(naming, socketDir, DefaultRMIClientSocketFactory.getInstance(), DefaultRMIServerSocketFactory.getInstance());
    }

    public AFUNIXRMISocketFactory(AFUNIXNaming naming, File socketDir, RMIClientSocketFactory defaultClientFactory, RMIServerSocketFactory defaultServerFactory) throws IOException {
        this(naming, socketDir, defaultClientFactory, defaultServerFactory, null, null);
    }

    public AFUNIXRMISocketFactory(AFUNIXNaming naming, File socketDir, RMIClientSocketFactory defaultClientFactory, RMIServerSocketFactory defaultServerFactory, String socketPrefix, String socketSuffix) throws IOException {
        this.naming = naming;
        this.socketDir = socketDir;
        this.defaultClientFactory = defaultClientFactory;
        this.defaultServerFactory = defaultServerFactory;
        this.socketPrefix = socketPrefix == null ? DEFAULT_SOCKET_FILE_PREFIX : socketPrefix;
        this.socketSuffix = socketSuffix == null ? DEFAULT_SOCKET_FILE_SUFFIX : socketSuffix;
        this.closeUponRuntimeShutdown();
    }

    private boolean isPlainFileSocket() {
        return this.naming.getRegistryPort() == Integer.MAX_VALUE;
    }

    void deleteStaleFiles() {
        if (this.isPlainFileSocket()) {
            return;
        }
        File sd = this.socketDir;
        if (sd == null) {
            return;
        }
        File[] files = sd.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(AFUNIXRMISocketFactory.this.socketPrefix) && name.endsWith(AFUNIXRMISocketFactory.this.socketSuffix);
            }
        });
        if (files == null) {
            return;
        }
        for (File f : files) {
            int port;
            String name = f.getName();
            String portName = name.substring(0, name.length() - this.socketSuffix.length()).substring(this.socketPrefix.length());
            try {
                port = Integer.parseInt(portName);
            }
            catch (Exception e) {
                port = -1;
            }
            if (port < 100000) continue;
            boolean connected = false;
            try (Socket s = this.createSocket(DEFAULT_SOCKET_FILE_PREFIX, port);){
                connected = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (connected) continue;
            try {
                Files.delete(f.toPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void closeUponRuntimeShutdown() {
        ShutdownHookSupport.addWeakShutdownHook(this);
    }

    public int hashCode() {
        return this.socketDir == null ? super.hashCode() : this.socketDir.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof AFUNIXRMISocketFactory)) {
            return false;
        }
        AFUNIXRMISocketFactory sf = (AFUNIXRMISocketFactory)other;
        return sf.socketDir.equals(this.socketDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Socket createSocket(String host, int port) throws IOException {
        RMIClientSocketFactory cf = this.defaultClientFactory;
        if (cf != null && port < 100000) {
            return cf.createSocket(host, port);
        }
        AFUNIXSocketAddress addr = new AFUNIXSocketAddress(this.getFile(port), port);
        AFUNIXSocket socket = AFUNIXSocket.newInstance();
        socket.connect((SocketAddress)addr);
        AFUNIXSocketCredentials creds = socket.getPeerCredentials();
        final HostAndPort hap = new HostAndPort(host, port);
        Map<HostAndPort, AFUNIXSocketCredentials> map = this.credentials;
        synchronized (map) {
            if (this.credentials.put(hap, creds) != null) {
                // empty if block
            }
        }
        socket.addCloseable(new Closeable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                if (AFUNIXRMISocketFactory.this.credentials == null) {
                    return;
                }
                Map map = AFUNIXRMISocketFactory.this.credentials;
                synchronized (map) {
                    AFUNIXRMISocketFactory.this.credentials.remove(hap);
                }
            }
        });
        return socket;
    }

    public File getSocketDir() {
        return this.socketDir;
    }

    File getFile(int port) {
        if (this.isPlainFileSocket()) {
            return this.socketDir;
        }
        return new File(this.socketDir, this.socketPrefix + port + this.socketSuffix);
    }

    void deleteSocketFile(int port) {
        try {
            Files.delete(this.getFile(port).toPath());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    boolean hasSocketFile(int port) {
        return this.getFile(port).exists();
    }

    @Override
    public void close() throws RemoteException {
        this.credentials = null;
        if (this.rmiService != null) {
            this.rmiService.openPorts().forEach(port -> this.deleteSocketFile(port));
        }
    }

    private AFUNIXRMIService getRmiService() throws IOException {
        if (this.rmiService == null) {
            try {
                this.rmiService = this.naming.getRMIService();
            }
            catch (NotBoundException e) {
                throw (IOException)new IOException(e.getMessage()).initCause(e);
            }
        }
        return this.rmiService;
    }

    protected int newPort() throws IOException {
        return this.getRmiService().newPort();
    }

    protected void returnPort(int port) throws IOException {
        this.deleteSocketFile(port);
        this.getRmiService().returnPort(port);
    }

    @Override
    public ServerSocket createServerSocket(int port) throws IOException {
        if (port == 0) {
            port = this.newPort();
            AFUNIXSocketAddress addr = new AFUNIXSocketAddress(this.getFile(port), port);
            AnonymousServerSocket ass = new AnonymousServerSocket(port);
            ass.bind((SocketAddress)addr);
            if (port >= 100000) {
                ass.addCloseable(new PortCloseable(port - 100000));
            }
            return ass;
        }
        RMIServerSocketFactory sf = this.defaultServerFactory;
        if (sf != null && port < 100000) {
            return sf.createServerSocket(port);
        }
        AFUNIXSocketAddress addr = new AFUNIXSocketAddress(this.getFile(port), port);
        AFUNIXServerSocket socket = AFUNIXServerSocket.bindOn((AFUNIXSocketAddress)addr);
        socket.addCloseable((Closeable)new PortCloseable(port - 100000));
        return socket;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.socketDir = new File(in.readUTF());
        int port = in.readInt();
        this.naming = AFUNIXNaming.getInstance(this.socketDir, port);
        this.defaultClientFactory = (RMIClientSocketFactory)in.readObject();
        this.defaultServerFactory = (RMIServerSocketFactory)in.readObject();
        this.socketPrefix = in.readUTF();
        this.socketSuffix = in.readUTF();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.socketDir.getAbsolutePath());
        out.writeInt(this.naming.getRegistryPort());
        out.writeObject(this.defaultClientFactory);
        out.writeObject(this.defaultServerFactory);
        out.writeUTF(this.socketPrefix);
        out.writeUTF(this.socketSuffix);
    }

    public String toString() {
        return super.toString() + "[path=" + this.socketDir + (String)(this.isPlainFileSocket() ? DEFAULT_SOCKET_FILE_PREFIX : ";prefix=" + this.socketPrefix + ";suffix=" + this.socketSuffix) + "]";
    }

    @Override
    public void onRuntimeShutdown(Thread thread) {
        if (thread != Thread.currentThread() || !(thread instanceof ShutdownHookSupport.ShutdownThread)) {
            throw new IllegalStateException("Illegal caller");
        }
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AFUNIXSocketCredentials peerCredentialsFor(RemotePeerInfo data) {
        Map<HostAndPort, AFUNIXSocketCredentials> map = this.credentials;
        synchronized (map) {
            return this.credentials.get(new HostAndPort(data.host, data.port));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocalServer(int port) {
        if (port < 100000) {
            return false;
        }
        BitSet bitSet = this.openServerPorts;
        synchronized (bitSet) {
            return this.openServerPorts.get(port - 100000);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class HostAndPort {
        final String hostname;
        final int port;

        private HostAndPort(String hostname, int port) {
            this.hostname = hostname;
            this.port = port;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.hostname == null ? 0 : this.hostname.hashCode());
            result = 31 * result + this.port;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof HostAndPort)) {
                return false;
            }
            HostAndPort other = (HostAndPort)obj;
            if (this.hostname == null ? other.hostname != null : !this.hostname.equals(other.hostname)) {
                return false;
            }
            return this.port == other.port;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private final class AnonymousServerSocket
    extends AFUNIXServerSocket {
        private final int returnPort;

        protected AnonymousServerSocket(int returnPort) throws IOException {
            this.returnPort = returnPort;
            this.setReuseAddress(true);
        }

        public void close() throws IOException {
            super.close();
            AFUNIXRMISocketFactory.this.returnPort(this.returnPort);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private final class PortCloseable
    implements Closeable {
        private final int port;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private PortCloseable(int port) {
            BitSet bitSet = AFUNIXRMISocketFactory.this.openServerPorts;
            synchronized (bitSet) {
                AFUNIXRMISocketFactory.this.openServerPorts.set(port);
            }
            this.port = port;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            BitSet bitSet = AFUNIXRMISocketFactory.this.openServerPorts;
            synchronized (bitSet) {
                AFUNIXRMISocketFactory.this.openServerPorts.clear(this.port);
            }
        }
    }
}

