/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.mysql;

import com.mysql.cj.ServerVersion;
import com.mysql.cj.conf.PropertySet;
import com.mysql.cj.conf.RuntimeProperty;
import com.mysql.cj.protocol.ExportControlled;
import com.mysql.cj.protocol.ServerSession;
import com.mysql.cj.protocol.SocketConnection;
import com.mysql.cj.protocol.SocketFactory;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketAddress;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class AFUNIXDatabaseSocketFactoryCJ
implements SocketFactory {
    private AFUNIXSocket rawSocket;
    private Socket sslSocket;

    public <T extends Closeable> T connect(String hostname, int portNumber, PropertySet props, int loginTimeout) throws IOException {
        RuntimeProperty prop = props.getStringProperty("junixsocket.file");
        String sock = prop != null && !prop.isExplicitlySet() ? prop.getStringValue() : "/tmp/mysql.sock";
        File socketFile = new File(sock);
        this.rawSocket = AFUNIXSocket.connectTo((AFUNIXSocketAddress)new AFUNIXSocketAddress(socketFile));
        this.sslSocket = this.rawSocket;
        return (T)this.rawSocket;
    }

    public <T extends Closeable> T performTlsHandshake(SocketConnection socketConnection, ServerSession serverSession) throws IOException {
        this.sslSocket = ExportControlled.performTlsHandshake((Socket)this.rawSocket, (SocketConnection)socketConnection, (ServerVersion)(serverSession == null ? null : serverSession.getServerVersion()));
        return (T)this.sslSocket;
    }
}

