/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.demo;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import org.newsclub.net.unix.AFInputStream;
import org.newsclub.net.unix.AFOutputStream;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketAddress;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class SimpleTestClient {
    public static void main(String[] args) throws IOException {
        File socketFile = new File(new File(System.getProperty("java.io.tmpdir")), "junixsocket-test.sock");
        boolean connected = false;
        try (AFUNIXSocket sock = AFUNIXSocket.connectTo((AFUNIXSocketAddress)AFUNIXSocketAddress.of((File)socketFile));
             AFInputStream is = sock.getInputStream();
             AFOutputStream os = sock.getOutputStream();
             DataInputStream din = new DataInputStream((InputStream)is);
             DataOutputStream dout = new DataOutputStream((OutputStream)os);){
            System.out.println("Connected");
            connected = true;
            byte[] buf = new byte[128];
            int read = is.read(buf);
            System.out.println("Server says: " + new String(buf, 0, read, StandardCharsets.UTF_8));
            System.out.println("Replying to server...");
            os.write("Hello Server".getBytes(StandardCharsets.UTF_8));
            os.flush();
            System.out.println("Now reading numbers from the server...");
            while (!Thread.interrupted()) {
                int number = din.readInt();
                if (number == -123) {
                    break;
                }
                System.out.println(number);
                int ourNumber = number * 2;
                System.out.println("Sending back " + ourNumber);
                dout.writeInt(ourNumber);
            }
        }
        catch (SocketException e) {
            if (!connected) {
                System.out.println("Cannot connect to server. Have you started it?");
                System.out.println();
            }
            throw e;
        }
        System.out.println("End of communication.");
    }
}

