/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.demo.ssl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class SSLDemoPrerequisites {
    private static final boolean runCommand(String explanation, String ... command) throws IOException, InterruptedException {
        System.out.println(explanation + "...");
        StringBuilder sb = new StringBuilder();
        for (String c : command) {
            sb.append(" ");
            if (c.isEmpty() || c.contains(" ") || c.contains("\"")) {
                sb.append("\"" + c.replace("\"", "\\\"") + "\"");
                continue;
            }
            sb.append(c);
        }
        System.out.println("#" + sb);
        Process process = Runtime.getRuntime().exec(command);
        CompletableFuture.runAsync(() -> {
            try (InputStream stdout = process.getInputStream();){
                int r;
                byte[] buf = new byte[1024];
                while ((r = stdout.read(buf)) >= 0) {
                    System.out.write(buf, 0, r);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        CompletableFuture.runAsync(() -> {
            try (InputStream stderr = process.getErrorStream();){
                int r;
                byte[] buf = new byte[1024];
                while ((r = stderr.read(buf)) >= 0) {
                    System.err.write(buf, 0, r);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        int rc = process.waitFor();
        System.out.println("rc=" + rc);
        System.out.println();
        return rc == 0;
    }

    public static void main(String[] args) throws Exception {
        System.out.println("Working directory: " + new File("").getAbsolutePath());
        System.out.println();
        boolean success = true;
        success &= SSLDemoPrerequisites.runCommand("Generating server key pair", "keytool", "-genkeypair", "-alias", "juxserver", "-keyalg", "RSA", "-keysize", "2048", "-storetype", "PKCS12", "-validity", "3650", "-ext", "san=dns:localhost.junixsocket", "-dname", "CN=First and Last, OU=Organizational Unit, O=Organization, L=City, ST=State, C=XX", "-keystore", "juxserver.p12", "-storepass", "serverpass");
        success &= SSLDemoPrerequisites.runCommand("Exporting server certificate", "keytool -exportcert -alias juxserver -keystore juxserver.p12 -storepass serverpass -file juxserver.pem".split("[ ]+"));
        success &= SSLDemoPrerequisites.runCommand("Importing server certificate into client truststore", "keytool -importcert -alias juxserver -keystore juxclient.truststore -storepass clienttrustpass -file juxserver.pem -noprompt".split("[ ]+"));
        success &= SSLDemoPrerequisites.runCommand("Generating client key pair (optional, only for client authentication)", "keytool", "-genkeypair", "-alias", "juxclient", "-keyalg", "RSA", "-keysize", "2048", "-storetype", "PKCS12", "-validity", "3650", "-ext", "san=dns:localhost.junixsocket", "-dname", "CN=First and Last, OU=Organizational Unit, O=Organization, L=City, ST=State, C=XX", "-keystore", "juxclient.p12", "-storepass", "clientpass");
        success &= SSLDemoPrerequisites.runCommand("Exporting client certificate (optional, only for client authentication)", "keytool -exportcert -alias juxclient -keystore juxclient.p12 -storepass clientpass -file juxclient.pem".split("[ ]+"));
        System.out.println("DONE. All successful=" + (success &= SSLDemoPrerequisites.runCommand("Importing client certificate server client truststore (optional, only for client authentication)", "keytool -importcert -alias juxclient -keystore juxserver.truststore -storepass servertrustpass -file juxclient.pem -noprompt".split("[ ]+"))));
    }
}

