/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.demo.rmi;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import java.io.IOException;
import java.rmi.NotBoundException;
import org.newsclub.net.unix.AFUNIXSocketCredentials;
import org.newsclub.net.unix.demo.rmi.services.HelloWorld;
import org.newsclub.net.unix.demo.rmi.services.World;
import org.newsclub.net.unix.rmi.AFNaming;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class HelloWorldImpl
implements HelloWorld {
    private final AFNaming naming;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public HelloWorldImpl(AFNaming naming) {
        this.naming = naming;
    }

    @Override
    public String hello() throws IOException {
        System.out.println("Received call to hello() from: " + String.valueOf(AFUNIXSocketCredentials.remotePeerCredentials()));
        return "Hello";
    }

    @Override
    public String world() throws IOException {
        try {
            return ((World)this.naming.lookup("world")).world();
        }
        catch (NotBoundException e) {
            return "world";
        }
    }
}

