/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.demo.jdbc;

import java.io.IOException;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.newsclub.net.unix.AFUNIXSocketFactory;
import org.newsclub.net.unix.demo.DemoHelper;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class PostgresDemo {
    public static void main(String[] args) throws SQLException, ClassNotFoundException, IOException {
        String url;
        DemoHelper.initJDBCDriverClass("postgresqlDriver", "org.postgresql.Driver", null);
        String databaseName = "postgres";
        int port = 12345;
        String socketPath = DemoHelper.getPropertyValue("socketPath", "/tmp/.s.PGSQL.5432", "/var/run/postgresql/.s.PGSQL.5432");
        new AFUNIXSocketFactory.URIScheme().createSocket("file://" + socketPath, port).close();
        String urlEncoded = URLEncoder.encode("file://" + socketPath, "UTF-8");
        System.out.println("urlEncoded: " + urlEncoded);
        System.out.println();
        String socketFactory = DemoHelper.getPropertyValue("socketFactory", "org.newsclub.net.unix.AFUNIXSocketFactory$FactoryArg", "org.newsclub.net.unix.AFUNIXSocketFactory$URIScheme", s -> {
            if (!s.isEmpty() && !s.contains(".")) {
                return "org.newsclub.net.unix.AFUNIXSocketFactory$" + s;
            }
            return s;
        });
        Properties props = new Properties();
        props.setProperty("socketFactory", socketFactory);
        DemoHelper.addProperty(props, "user", System.getProperty("user.name"), "postgresqlUser", "root");
        DemoHelper.addProperty(props, "password", "", "postgresqlPassword", "secret");
        DemoHelper.addProperty(props, "sslMode", "disable", "postgresqlSslMode", "prefer");
        if ("org.newsclub.net.unix.AFUNIXSocketFactory$URIScheme".equals(socketFactory)) {
            url = "jdbc:postgresql://[" + urlEncoded + ":" + port + "/" + databaseName;
        } else {
            url = "jdbc:postgresql://localhost/postgres";
            if ("org.newsclub.net.unix.AFUNIXSocketFactory$FactoryArg".equals(socketFactory)) {
                DemoHelper.addProperty(props, "socketFactoryArg", socketPath, "socketFactoryArg", null);
            }
        }
        System.out.println();
        System.out.println("Connecting to db: " + url);
        System.out.println();
        try (Connection conn = DriverManager.getConnection(url, props);){
            System.out.println("Connection " + conn);
            DatabaseMetaData metadata = conn.getMetaData();
            System.out.println("Database version: " + metadata.getDatabaseProductName() + " " + metadata.getDatabaseProductVersion());
            String sql = "SHOW ALL";
            System.out.println(sql);
            try (Statement stmt = conn.createStatement();
                 ResultSet rs = stmt.executeQuery(sql);){
                while (rs.next()) {
                    System.out.println("* " + rs.getString(1) + "=" + rs.getString(2));
                }
            }
        }
    }
}

