/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.demo.rmi;

import java.rmi.Remote;
import java.rmi.server.RemoteObject;
import org.newsclub.net.unix.demo.rmi.WorldImpl;
import org.newsclub.net.unix.demo.rmi.services.HelloWorld;
import org.newsclub.net.unix.rmi.AFUNIXNaming;
import org.newsclub.net.unix.rmi.AFUNIXRegistry;
import org.newsclub.net.unix.rmi.RemotePeerInfo;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class SimpleRMIClientActingAsServer {
    public static void main(String[] args) throws Exception {
        AFUNIXNaming naming = AFUNIXNaming.getInstance();
        System.out.println("Locating registry...");
        AFUNIXRegistry registry = naming.getRegistry();
        System.out.println(registry);
        System.out.println();
        HelloWorld obj = (HelloWorld)registry.lookup("helloWorld");
        System.out.println("HelloWorld instance:");
        System.out.println("    " + obj);
        System.out.println("    " + RemotePeerInfo.remotePeerCredentials((Remote)obj));
        System.out.println();
        WorldImpl world = new WorldImpl("everybody");
        naming.exportAndRebind("world", (Remote)world);
        System.out.println("Exporting our own World instance:");
        System.out.println("    " + RemoteObject.toStub(world));
        System.out.println("    " + RemotePeerInfo.remotePeerCredentials((Remote)world));
        System.out.println();
        System.out.println("Calling HelloWorld...");
        System.out.println(obj.hello() + " " + obj.world() + "!");
        naming.unexportAndUnbind("world", (Remote)world);
    }
}

