/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.mysql.demo;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import org.newsclub.net.unix.demo.DemoHelper;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class AFUNIXDatabaseSocketFactoryDemo {
    public static void main(String[] args) throws Exception {
        DemoHelper.initJDBCDriverClass("mysqlDriver", "", "com.mysql.jdbc.Driver");
        System.out.println();
        String connectionUrl = "jdbc:mysql://";
        System.out.println("Connection URL=jdbc:mysql://");
        Properties props = new Properties();
        DemoHelper.addProperty(props, "socketFactory", "org.newsclub.net.mysql.AFUNIXDatabaseSocketFactory", "mysqlSocketFactory", "org.newsclub.net.mysql.AFUNIXDatabaseSocketFactoryCJ");
        DemoHelper.addProperty(props, "junixsocket.file", "/tmp/mysql.sock", "mysqlSocket", "/var/lib/mysql.sock");
        DemoHelper.addProperty(props, "user", "root", "mysqlUser", "test");
        DemoHelper.addProperty(props, "password", "", "mysqlPassword", "test");
        DemoHelper.addProperty(props, "sslMode", "PREFERRED", "mysqlSslMode", "DISABLED");
        System.out.println();
        Connection conn = DriverManager.getConnection("jdbc:mysql://", props);
        System.out.println("Connection: " + conn);
        DatabaseMetaData metadata = conn.getMetaData();
        System.out.println("Database version: " + metadata.getDatabaseProductName() + " " + metadata.getDatabaseProductVersion());
        String sql = "SHOW DATABASES";
        System.out.println(sql);
        try (Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery(sql);){
            while (rs.next()) {
                System.out.println("* " + rs.getString(1));
            }
        }
    }
}

