/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.demo;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketAddress;
import org.newsclub.net.unix.AFUNIXServerSocket;
import org.newsclub.net.unix.AFUNIXSocketAddress;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class SimpleTestServer {
    public static void main(String[] args) throws IOException {
        File socketFile = new File(new File(System.getProperty("java.io.tmpdir")), "junixsocket-test.sock");
        try (AFUNIXServerSocket server = AFUNIXServerSocket.newInstance();){
            server.bind((SocketAddress)new AFUNIXSocketAddress(socketFile));
            System.out.println("server: " + server);
            while (!Thread.interrupted()) {
                System.out.println("Waiting for connection...");
                Socket sock = server.accept();
                try {
                    System.out.println("Connected: " + sock);
                    InputStream is = sock.getInputStream();
                    try {
                        OutputStream os = sock.getOutputStream();
                        try {
                            System.out.println("Saying hello to client " + os);
                            os.write("Hello, dear Client".getBytes("UTF-8"));
                            os.flush();
                            byte[] buf = new byte[128];
                            int read = is.read(buf);
                            System.out.println("Client's response: " + new String(buf, 0, read, "UTF-8"));
                        }
                        finally {
                            if (os == null) continue;
                            os.close();
                        }
                    }
                    finally {
                        if (is == null) continue;
                        is.close();
                    }
                }
                finally {
                    if (sock == null) continue;
                    sock.close();
                }
            }
        }
    }
}

