/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.nio.channels.spi.AbstractSelector;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.newsclub.net.unix.AFPipe;
import org.newsclub.net.unix.AFSelectionKey;
import org.newsclub.net.unix.AFSelectorProvider;
import org.newsclub.net.unix.AFUNIXSelectorProvider;
import org.newsclub.net.unix.NativeUnixSocket;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class AFSelector
extends AbstractSelector {
    private static AFPipe sharedSelectorPipe = null;
    private static PollFd sharedSelectorPipePollFd;
    private static final ByteBuffer PIPE_MSG_WAKE_UP;
    private static final ByteBuffer PIPE_MSG_RECEIVE_BUFFER;
    private final Set<AFSelectionKey> keysRegistered = new HashSet<AFSelectionKey>();
    private final Set<SelectionKey> keysView = Collections.unmodifiableSet(this.keysRegistered);
    private PollFd pollFd = null;
    private final SelectionKeySet keysSelected = new SelectionKeySet();

    protected AFSelector(AFSelectorProvider<?> provider) {
        super(provider);
    }

    private static synchronized AFPipe getSharedSelectorPipe() throws IOException {
        if (sharedSelectorPipe == null) {
            sharedSelectorPipe = AFUNIXSelectorProvider.getInstance().openSelectablePipe();
            sharedSelectorPipePollFd = new PollFd(sharedSelectorPipe.sourceFD());
        }
        return sharedSelectorPipe;
    }

    protected AFPipe selectorPipe() throws IOException {
        return AFSelector.getSharedSelectorPipe();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected SelectionKey register(AbstractSelectableChannel ch, int ops, Object att) {
        AFSelectionKey key = new AFSelectionKey(this, ch, ops, att);
        AFSelector aFSelector = this;
        synchronized (aFSelector) {
            this.pollFd = null;
            this.keysRegistered.add(key);
        }
        return key;
    }

    @Override
    public Set<SelectionKey> keys() {
        return this.keysView;
    }

    @Override
    public Set<SelectionKey> selectedKeys() {
        return this.keysSelected;
    }

    @Override
    public int selectNow() throws IOException {
        return this.select0(0);
    }

    @Override
    public int select(long timeout) throws IOException {
        if (timeout > Integer.MAX_VALUE) {
            timeout = Integer.MAX_VALUE;
        } else if (timeout < 0L) {
            throw new IllegalArgumentException("Timeout must not be negative");
        }
        return this.select0((int)timeout);
    }

    @Override
    public int select() throws IOException {
        try {
            return this.select0(-1);
        }
        catch (SocketTimeoutException e) {
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int select0(int timeout) throws IOException {
        int num;
        PollFd pfd;
        AFSelector aFSelector = this;
        synchronized (aFSelector) {
            if (!this.isOpen()) {
                throw new ClosedSelectorException();
            }
            pfd = this.pollFd = this.initPollFd(this.pollFd);
            this.keysSelected.clear();
        }
        try {
            this.begin();
            num = NativeUnixSocket.poll(pfd, timeout);
        }
        finally {
            this.end();
        }
        AFSelector aFSelector2 = this;
        synchronized (aFSelector2) {
            AFSelectionKey[] keys;
            pfd = this.pollFd;
            if (pfd != null && (keys = pfd.keys) != null) {
                for (AFSelectionKey key : keys) {
                    SelectableChannel ch;
                    if (key == null || !key.hasOpInvalid() || (ch = key.channel()) == null || !ch.isOpen()) continue;
                    ch.close();
                }
            }
            if (num > 0) {
                this.consumeAllBytesAfterPoll();
                this.setOpsReady();
            }
            return this.keysSelected.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void consumeAllBytesAfterPoll() throws IOException {
        int bytesReceived;
        int maxReceive;
        if (this.pollFd == null) {
            return;
        }
        if ((this.pollFd.rops[0] & 1) == 0) {
            return;
        }
        int options = this.selectorPipe().getOptions();
        ByteBuffer byteBuffer = PIPE_MSG_RECEIVE_BUFFER;
        synchronized (byteBuffer) {
            PIPE_MSG_RECEIVE_BUFFER.clear();
            maxReceive = PIPE_MSG_RECEIVE_BUFFER.remaining();
            bytesReceived = NativeUnixSocket.receive(this.pollFd.fds[0], PIPE_MSG_RECEIVE_BUFFER, 0, maxReceive, null, options, null, 1);
        }
        if (bytesReceived == maxReceive && maxReceive > 0) {
            int read;
            do {
                if ((read = NativeUnixSocket.poll(sharedSelectorPipePollFd, 0)) <= 0) continue;
                ByteBuffer byteBuffer2 = PIPE_MSG_RECEIVE_BUFFER;
                synchronized (byteBuffer2) {
                    PIPE_MSG_RECEIVE_BUFFER.clear();
                    read = NativeUnixSocket.receive(AFSelector.sharedSelectorPipePollFd.fds[0], PIPE_MSG_RECEIVE_BUFFER, 0, maxReceive, null, options, null, 1);
                }
            } while (read == maxReceive && read > 0);
        }
    }

    private synchronized void setOpsReady() {
        if (this.pollFd == null) {
            return;
        }
        for (int i = 1; i < this.pollFd.rops.length; ++i) {
            int rops = this.pollFd.rops[i];
            if (rops == 0) continue;
            AFSelectionKey key = this.pollFd.keys[i];
            key.setOpsReady(rops);
            this.keysSelected.add0(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PollFd initPollFd(PollFd existingPollFd) throws IOException {
        AFSelector aFSelector = this;
        synchronized (aFSelector) {
            Iterator<AFSelectionKey> it = this.keysRegistered.iterator();
            while (it.hasNext()) {
                AFSelectionKey key = it.next();
                if (key.getAFCore().fd.valid()) continue;
                key.cancelNoRemove();
                it.remove();
                existingPollFd = null;
            }
            if (existingPollFd != null) {
                return existingPollFd;
            }
            int size = this.keysRegistered.size() + 1;
            FileDescriptor[] fds = new FileDescriptor[size];
            int[] ops = new int[size];
            AFSelectionKey[] keys = new AFSelectionKey[size];
            fds[0] = this.selectorPipe().sourceFD();
            ops[0] = 1;
            int i = 1;
            Iterator<AFSelectionKey> iterator = this.keysRegistered.iterator();
            while (iterator.hasNext()) {
                AFSelectionKey key;
                keys[i] = key = iterator.next();
                fds[i] = key.getAFCore().fd;
                ops[i] = key.interestOps();
                ++i;
            }
            return new PollFd(keys, fds, ops);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void implCloseSelector() throws IOException {
        this.wakeup();
        AFSelector aFSelector = this;
        synchronized (aFSelector) {
            for (AFSelectionKey key : this.keysRegistered) {
                key.cancelNoRemove();
            }
            this.keysRegistered.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Selector wakeup() {
        if (this.isOpen()) {
            try {
                ByteBuffer byteBuffer = PIPE_MSG_WAKE_UP;
                synchronized (byteBuffer) {
                    PIPE_MSG_WAKE_UP.clear();
                    this.selectorPipe().sink().write(PIPE_MSG_WAKE_UP);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this;
    }

    synchronized void remove(AFSelectionKey key) {
        this.deregister(key);
        this.keysRegistered.remove(key);
        this.keysSelected.remove(key);
        this.pollFd = null;
    }

    private void deregister(AFSelectionKey key) {
        try {
            NativeUnixSocket.deregisterSelectionKey((AbstractSelectableChannel)key.channel(), key);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    static {
        PIPE_MSG_WAKE_UP = ByteBuffer.allocate(1);
        PIPE_MSG_RECEIVE_BUFFER = ByteBuffer.allocateDirect(256);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static final class PollFd {
        final FileDescriptor[] fds;
        final int[] ops;
        final int[] rops;
        final AFSelectionKey[] keys;

        PollFd(FileDescriptor pipeSourceFd) {
            this(pipeSourceFd, 1);
        }

        PollFd(FileDescriptor pipeSourceFd, int op) {
            this.fds = new FileDescriptor[]{pipeSourceFd};
            this.ops = new int[]{op};
            this.rops = new int[1];
            this.keys = null;
        }

        PollFd(AFSelectionKey[] keys, FileDescriptor[] fds, int[] ops) {
            this.keys = keys;
            if (fds.length != ops.length) {
                throw new IllegalStateException();
            }
            this.fds = fds;
            this.ops = ops;
            this.rops = new int[ops.length];
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class SelectionKeySet
    extends HashSet<SelectionKey> {
        private static final long serialVersionUID = 1L;

        private SelectionKeySet() {
        }

        @Override
        public boolean add(SelectionKey e) {
            throw new UnsupportedOperationException();
        }

        private void add0(SelectionKey e) {
            super.add(e);
        }

        @Override
        public boolean addAll(Collection<? extends SelectionKey> c) {
            throw new UnsupportedOperationException();
        }
    }
}

