/*
 * junixsocket
 *
 * Copyright 2009-2024 Christian Kohlschütter
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.newsclub.net.unix;

import java.net.SocketException;

/**
 * A {@link SocketException} indicating that a socket was not bound when attempting to read or
 * write.
 *
 * @author Christian Kohlschütter
 */
public final class NotBoundSocketException extends SocketException {
  private static final long serialVersionUID = 1L;

  /**
   * Constructs a new {@link NotBoundSocketException}.
   */
  public NotBoundSocketException() {
    super();
  }
}
