/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.AFUNIXSocketFactory;
import org.newsclub.net.unix.AFUNIXSocketImpl;
import org.newsclub.net.unix.NativeUnixSocket;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class AFUNIXSocket
extends Socket {
    private static final String PROP_LIBRARY_LOADED = "org.newsclub.net.unix.library.loaded";
    protected AFUNIXSocketImpl impl;
    AFUNIXSocketAddress addr;
    private final AFUNIXSocketFactory socketFactory;

    private AFUNIXSocket(AFUNIXSocketImpl impl, AFUNIXSocketFactory factory) throws IOException {
        super(impl);
        this.socketFactory = factory;
        if (factory == null) {
            this.setIsCreated();
        }
    }

    private void setIsCreated() throws IOException {
        try {
            NativeUnixSocket.setCreated(this);
        }
        catch (LinkageError e) {
            throw new IOException("Couldn't load native library", e);
        }
    }

    public static AFUNIXSocket newInstance() throws IOException {
        return AFUNIXSocket.newInstance(null);
    }

    static AFUNIXSocket newInstance(AFUNIXSocketFactory factory) throws IOException {
        AFUNIXSocketImpl.Lenient impl = new AFUNIXSocketImpl.Lenient();
        AFUNIXSocket instance = new AFUNIXSocket(impl, factory);
        instance.impl = impl;
        return instance;
    }

    public static AFUNIXSocket newStrictInstance() throws IOException {
        AFUNIXSocketImpl impl = new AFUNIXSocketImpl();
        AFUNIXSocket instance = new AFUNIXSocket(impl, null);
        instance.impl = impl;
        return instance;
    }

    public static AFUNIXSocket connectTo(AFUNIXSocketAddress addr) throws IOException {
        AFUNIXSocket socket = AFUNIXSocket.newInstance();
        socket.connect(addr);
        return socket;
    }

    @Override
    public void bind(SocketAddress bindpoint) throws IOException {
        super.bind(bindpoint);
        this.addr = (AFUNIXSocketAddress)bindpoint;
    }

    @Override
    public void connect(SocketAddress endpoint) throws IOException {
        this.connect(endpoint, 0);
    }

    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        if (!(endpoint instanceof AFUNIXSocketAddress)) {
            InetSocketAddress isa;
            String hostname;
            if (this.socketFactory != null && endpoint instanceof InetSocketAddress && this.socketFactory.isHostnameSupported(hostname = (isa = (InetSocketAddress)endpoint).getHostString())) {
                endpoint = this.socketFactory.addressFromHost(hostname, isa.getPort());
            }
            if (!(endpoint instanceof AFUNIXSocketAddress)) {
                throw new IllegalArgumentException("Can only connect to endpoints of type " + AFUNIXSocketAddress.class.getName() + ", got: " + endpoint);
            }
        }
        this.impl.connect(endpoint, timeout);
        this.addr = (AFUNIXSocketAddress)endpoint;
        NativeUnixSocket.setConnected(this);
    }

    @Override
    public String toString() {
        if (this.isConnected()) {
            return "AFUNIXSocket[fd=" + this.impl.getFD() + ";path=" + this.addr.getSocketFile() + "]";
        }
        return "AFUNIXSocket[unconnected]";
    }

    public static boolean isSupported() {
        return NativeUnixSocket.isLoaded();
    }

    public static String getLoadedLibrary() {
        return System.getProperty(PROP_LIBRARY_LOADED);
    }
}

