/*
 * Decompiled with CFR 0.152.
 */
package com.kirich1409.svgloader.glide.utils;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.RectF;
import android.support.annotation.FloatRange;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.RestrictTo;
import com.caverock.androidsvg.SVG;
import com.caverock.androidsvg.SVGParseException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class SvgUtils {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void fix(@NonNull SVG svg) throws IOException {
        RectF viewBox = svg.getDocumentViewBox();
        float docWidth = svg.getDocumentWidth();
        float docHeight = svg.getDocumentHeight();
        if (viewBox == null) {
            if (!(docWidth > 0.0f) || !(docHeight > 0.0f)) throw new IOException("SVG must have specify 'width' & 'height' tags or 'viewbox'");
            svg.setDocumentViewBox(0.0f, 0.0f, docWidth, docHeight);
            return;
        } else if (docWidth <= 0.0f && docHeight <= 0.0f) {
            svg.setDocumentWidth(viewBox.width());
            svg.setDocumentHeight(viewBox.height());
            return;
        } else if (docWidth <= 0.0f) {
            svg.setDocumentWidth(SvgUtils.aspectRation(viewBox) * docHeight);
            return;
        } else {
            if (!(docHeight <= 0.0f)) return;
            svg.setDocumentHeight(docWidth / SvgUtils.aspectRation(viewBox));
        }
    }

    private static float aspectRation(@NonNull RectF rect) {
        return rect.width() / rect.height();
    }

    public static SVG getSvg(@NonNull File file) throws SVGParseException, IOException {
        if (!file.exists()) {
            throw new FileNotFoundException("File: '" + file.getAbsolutePath() + "' not exists");
        }
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));){
            SVG sVG = SVG.getFromInputStream((InputStream)is);
            return sVG;
        }
    }

    public static SVG getSvg(@NonNull FileDescriptor descriptor) throws SVGParseException, IOException {
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(descriptor));){
            SVG sVG = SVG.getFromInputStream((InputStream)is);
            return sVG;
        }
    }

    public static void scaleDocumentSize(@NonNull SVG svg, @FloatRange(from=0.0, fromInclusive=false) float scale) {
        svg.setDocumentWidth(svg.getDocumentWidth() * scale);
        svg.setDocumentHeight(svg.getDocumentHeight() * scale);
    }

    @NonNull
    public static Bitmap toBitmap(@NonNull SVG svg, @NonNull BitmapProvider provider, @NonNull Bitmap.Config config) {
        int outImageWidth = Math.round(svg.getDocumentWidth());
        int outImageHeight = Math.round(svg.getDocumentHeight());
        Bitmap bitmap = provider.get(outImageWidth, outImageHeight, config);
        Canvas canvas = new Canvas(bitmap);
        svg.renderToCanvas(canvas);
        return bitmap;
    }

    private SvgUtils() {
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static interface BitmapProvider {
        @NonNull
        public Bitmap get(@IntRange(from=0L) int var1, @IntRange(from=0L) int var2, @NonNull Bitmap.Config var3);
    }
}

