/*
 * Decompiled with CFR 0.152.
 */
package com.kirich1409.svgloader.glide.utils;

import android.content.res.Resources;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RawRes;
import android.support.annotation.RestrictTo;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class ResourceUtils {
    private static final int NAME_URI_PATH_SEGMENTS = 2;
    private static final int ID_PATH_SEGMENTS = 1;
    private static final int TYPE_PATH_SEGMENT_INDEX = 0;
    private static final int NAME_PATH_SEGMENT_INDEX = 1;
    private static final int RES_ID_SEGMENT_INDEX = 0;
    private static final String RESOURCE_TYPE_RAW = "raw";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RawRes
    public static int getRawResourceId(@NonNull Resources resources, @NonNull Uri source) {
        int resId;
        List segments = source.getPathSegments();
        if (segments.size() == 2) {
            String typeName = (String)segments.get(0);
            ResourceUtils.checkResourceType(typeName);
            String packageName = source.getAuthority();
            String resourceName = (String)segments.get(1);
            resId = resources.getIdentifier(resourceName, typeName, packageName);
        } else {
            if (segments.size() != 1) throw new IllegalArgumentException("Unrecognized Uri format: " + source);
            try {
                resId = Integer.valueOf((String)segments.get(0));
                if (resId != 0) {
                    ResourceUtils.checkResourceType(resources.getResourceTypeName(resId));
                }
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Unrecognized Uri format: " + source, e);
            }
        }
        if (resId != 0) return resId;
        throw new IllegalArgumentException("Failed to obtain resource id for: " + source);
    }

    private static void checkResourceType(@Nullable String resType) {
        if (!RESOURCE_TYPE_RAW.equals(resType)) {
            throw new IllegalArgumentException("Unsupported resource type: " + resType);
        }
    }

    public static boolean isRawResource(@NonNull Resources resources, @NonNull Uri uri) {
        if (!"android.resource".equals(uri.getScheme())) {
            return false;
        }
        List pathSegments = uri.getPathSegments();
        if (pathSegments.size() == 2) {
            return RESOURCE_TYPE_RAW.equals(pathSegments.get(0));
        }
        if (pathSegments.size() == 1) {
            try {
                int resId = Integer.parseInt((String)pathSegments.get(0));
                return resId != 0 && RESOURCE_TYPE_RAW.equals(resources.getResourceTypeName(resId));
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    private ResourceUtils() {
    }
}

