/*
 * Decompiled with CFR 0.152.
 */
package com.kirich1409.svgloader.glide.decoder;

import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import com.bumptech.glide.load.Options;
import com.bumptech.glide.load.ResourceDecoder;
import com.bumptech.glide.load.engine.Resource;
import com.caverock.androidsvg.SVG;
import com.caverock.androidsvg.SVGParseException;
import com.kirich1409.svgloader.glide.SvgResource;
import java.io.IOException;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public abstract class SvgDecoder<T>
implements ResourceDecoder<T, SVG> {
    public boolean handles(@NonNull T source, @NonNull Options options) throws IOException {
        return true;
    }

    @Nullable
    public Resource<SVG> decode(@NonNull T source, int width, int height, @NonNull Options options) throws IOException {
        try {
            int sourceSize = this.getSize(source);
            SVG svg = this.loadSvg(source, width, height, options);
            return new SvgResource(svg, width, height, sourceSize);
        }
        catch (SVGParseException e) {
            throw new IOException("Cannot load SVG", e);
        }
    }

    @IntRange(from=0L)
    protected abstract int getSize(@NonNull T var1) throws IOException;

    abstract SVG loadSvg(T var1, int var2, int var3, @NonNull Options var4) throws SVGParseException;
}

