/*
 * Decompiled with CFR 0.152.
 */
package com.kirich1409.svgloader.glide.decoder;

import android.content.Context;
import android.content.res.Resources;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.RestrictTo;
import com.bumptech.glide.load.Options;
import com.caverock.androidsvg.SVG;
import com.caverock.androidsvg.SVGParseException;
import com.kirich1409.svgloader.glide.decoder.SvgDecoder;
import com.kirich1409.svgloader.glide.utils.ResourceUtils;
import com.kirich1409.svgloader.glide.utils.SizeUtils;
import java.io.IOException;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class RawResourceSvgDecoder
extends SvgDecoder<Uri> {
    private final Resources mResources;

    public RawResourceSvgDecoder(@NonNull Context context) {
        this.mResources = context.getResources();
    }

    @Override
    public boolean handles(@NonNull Uri source, @NonNull Options options) {
        return ResourceUtils.isRawResource(this.mResources, source);
    }

    @Override
    SVG loadSvg(Uri source, int width, int height, @NonNull Options options) throws SVGParseException {
        return SVG.getFromResource((Resources)this.mResources, (int)ResourceUtils.getRawResourceId(this.mResources, source));
    }

    @Override
    protected int getSize(@NonNull Uri source) throws IOException {
        return SizeUtils.getRawResourceSize(this.mResources, source);
    }
}

